<?php
session_start();
require_once __DIR__ . '/../config/database.php';

// Cek login admin
if (!isset($_SESSION['login']) || ($_SESSION['user']['role'] ?? '') !== 'admin') {
    header("Location: login.php");
    exit;
}

$page_title = 'Profil Guru & Manajemen';

// Folder upload foto
$fotoFolder = '../uploads/guru-manajemen/';
$uploadDir = __DIR__ . '/../uploads/guru-manajemen/';

// Buat folder otomatis jika belum ada
if (!is_dir($uploadDir)) {
    mkdir($uploadDir, 0755, true);
}

// ================= TAMBAH PROFIL =================
if (isset($_POST['tambah'])) {
    $nama = $_POST['nama'];
    $jabatan = $_POST['jabatan'];
    $tempat_lahir = $_POST['tempat_lahir'];
    $tanggal_lahir = $_POST['tanggal_lahir'];
    $nip = $_POST['nip'];
    $pendidikan = $_POST['pendidikan'];
    $alamat = $_POST['alamat'];
    $wa = $_POST['wa'];
    $email = $_POST['email'];
    $status = $_POST['status'];
$bidang = $_POST['bidang'];
$keahlian = $_POST['keahlian'];

    $foto = null;
    if (!empty($_FILES['foto']['name'])) {
        $ext = pathinfo($_FILES['foto']['name'], PATHINFO_EXTENSION);
        $foto = time() . '_' . rand(100, 999) . '.' . $ext;
        move_uploaded_file($_FILES['foto']['tmp_name'], $uploadDir . $foto);
    }

    mysqli_query($conn, "INSERT INTO guru_manajemen 
(nama,jabatan,tempat_lahir,tanggal_lahir,nip,pendidikan,alamat,wa,email,foto,status,bidang,keahlian)
VALUES('$nama','$jabatan','$tempat_lahir','$tanggal_lahir','$nip','$pendidikan','$alamat','$wa','$email','$foto','$status','$bidang','$keahlian')
");
    header("Location: guru_manajemen.php");
    exit;
}

// ================= EDIT PROFIL =================
if (isset($_POST['edit'])) {
    $id = intval($_POST['id']);
    $nama = $_POST['nama'];
    $jabatan = $_POST['jabatan'];
    $tempat_lahir = $_POST['tempat_lahir'];
    $tanggal_lahir = $_POST['tanggal_lahir'];
    $nip = $_POST['nip'];
    $pendidikan = $_POST['pendidikan'];
    $alamat = $_POST['alamat'];
    $wa = $_POST['wa'];
    $email = $_POST['email'];
    $status = $_POST['status'];
$bidang = $_POST['bidang'];
$keahlian = $_POST['keahlian'];
    $fotoLama = $_POST['foto_lama'];

    $foto = $fotoLama;
    if (!empty($_FILES['foto']['name'])) {
        if ($foto && file_exists($uploadDir . $foto)) unlink($uploadDir . $foto);
        $ext = pathinfo($_FILES['foto']['name'], PATHINFO_EXTENSION);
        $foto = time() . '_' . rand(100, 999) . '.' . $ext;
        move_uploaded_file($_FILES['foto']['tmp_name'], $uploadDir . $foto);
    }

    mysqli_query($conn, "UPDATE guru_manajemen SET 
    nama='$nama',
    jabatan='$jabatan',
    tempat_lahir='$tempat_lahir',
    tanggal_lahir='$tanggal_lahir',
    nip='$nip',
    pendidikan='$pendidikan',
    alamat='$alamat',
    wa='$wa',
    email='$email',
    foto='$foto',
    status='$status',
    bidang='$bidang',
    keahlian='$keahlian'
    WHERE id=$id
");
    header("Location: guru_manajemen.php");
    exit;
}

// ================= HAPUS PROFIL =================
if (isset($_GET['hapus'])) {
    $id = intval($_GET['hapus']);
    $q = mysqli_query($conn, "SELECT foto FROM guru_manajemen WHERE id=$id");
    $r = mysqli_fetch_assoc($q);
    if ($r['foto'] && file_exists($uploadDir . $r['foto'])) unlink($uploadDir . $r['foto']);
    mysqli_query($conn, "DELETE FROM guru_manajemen WHERE id=$id");
    header("Location: guru_manajemen.php");
    exit;
}

// Ambil semua profil
$profils = mysqli_query($conn, "SELECT * FROM guru_manajemen ORDER BY 
FIELD(status,'Pembina','Kepala Sekolah','Manajemen','Tenaga Ahli','Guru'),
nama ASC");
?>

<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title><?= $page_title ?></title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
<style>
body {background:#f4f6f9; font-family:'Segoe UI',sans-serif; padding-bottom:70px;}
.sidebar {position:fixed; left:0; top:0; width:260px; height:100%; background:#0b1c2d; padding-top:20px; overflow:auto;}
.sidebar a {display:block; color:#fff; text-decoration:none; padding:12px 20px; font-weight:500;}
.sidebar a:hover {background:#0d6efd;}
.main-content {margin-left:260px; padding:20px;}
@media(max-width:768px){ .sidebar{display:none} .main-content{margin-left:0;} }

.table img {width:60px; height:60px; object-fit:cover; border-radius:50%;}

.topbar {display:flex; align-items:center; padding:10px 20px; background:#f4f6f9; color:#0b1c2d; position:relative; z-index:10;}
.page-title {font-weight:600; font-size:1.1rem; margin-left:10px; color:#0b1c2d;}
@media(min-width:768px){ .page-title {margin-left:260px;} }

.modal .form-control {margin-bottom:10px;}
.modal-body .form-label{
  font-weight:600;
  font-size:.9rem;
  margin-bottom:4px;
}
.modal-body .form-control{
  border-radius:6px;
}
.modal-body .row > div{
  margin-bottom:10px;
}
/* ===== MODAL RAPAPI ===== */
.modal-dialog{
    max-width:800px;
}

.modal-content{
    border-radius:14px;
}

.modal-header{
    background:#0d6efd;
    color:#fff;
}

.modal-header .btn-close{
    filter:invert(1);
}

.modal-body{
    padding:20px;
}

.modal-body .form-label{
    font-weight:600;
    font-size:.9rem;
    margin-bottom:4px;
}

.modal-body .form-control,
.modal-body .form-select{
    border-radius:8px;
}

.modal-body .row > div{
    margin-bottom:12px;
}

.modal-photo-preview{
    width:120px;
    height:120px;
    object-fit:cover;
    border-radius:50%;
    border:3px solid #eee;
    margin-bottom:10px;
}

@media(max-width:768px){
    .modal-dialog{
        max-width:95%;
    }
}
/* FIX MODAL CLICK BUG */
.modal{
    z-index: 2000 !important;
}

.modal-backdrop{
    z-index: 1990 !important;
}

/* Turunkan layer sidebar & topbar */
.sidebar{
    z-index: 1000 !important;
}

.topbar{
    z-index: 900 !important;
}

</style>
</head>
<body>

<?php include __DIR__ . '/partials/sidebar.php'; ?>

<div class="topbar d-flex align-items-center mb-3">
    <button class="btn btn-outline-primary d-lg-none me-2" type="button" data-bs-toggle="offcanvas" data-bs-target="#sidebarAdmin">
        <i class="bi bi-list"></i>
    </button>
    <h1 class="page-title mb-0"><?= $page_title ?></h1>
</div>

<div class="main-content container-fluid">
<div class="d-flex justify-content-between align-items-center mb-3">
    <h5 class="mb-0"><i class="bi bi-diagram-3"></i> Profil Guru & Manajemen PKBM TARUNA QURANI</h5>
    <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#tambahModal">
        <i class="bi bi-plus-circle"></i> Tambah Profil
    </button>
</div>

<div class="table-responsive">
<table class="table table-bordered table-striped align-middle text-center">
<thead class="table-dark">
<tr>
<th>No</th><th>Foto</th><th>Nama</th><th>Jabatan</th>
<th>Tempat Lahir</th><th>Tanggal Lahir</th><th>NIP/NUPTK</th>
<th>Pendidikan</th><th>Alamat</th><th>No. Telp</th><th>Email</th><th>Status</th>
<th>Bidang</th><th>Aksi</th>
</tr>
</thead>

<tbody>
<?php 
$no=1; 
$modalBuffer='';
while($p = mysqli_fetch_assoc($profils)): 
?>

<tr>
<td><?= $no++ ?></td>
<td><img src="<?= $fotoFolder . ($p['foto'] ?: 'default.png') ?>"></td>
<td><?= htmlspecialchars($p['nama']) ?></td>
<td><?= htmlspecialchars($p['jabatan']) ?></td>
<td><?= htmlspecialchars($p['tempat_lahir'] ?: '-') ?></td>
<td><?= htmlspecialchars($p['tanggal_lahir'] ?: '-') ?></td>
<td><?= htmlspecialchars($p['nip'] ?: '-') ?></td>
<td><?= htmlspecialchars($p['pendidikan'] ?: '-') ?></td>
<td><?= htmlspecialchars($p['alamat'] ?: '-') ?></td>
<td><?= htmlspecialchars($p['wa'] ?: '-') ?></td>
<td><?= htmlspecialchars($p['email'] ?: '-') ?></td>

<td>
<?php
$status = $p['status'] ?? '-';

$badgeClass = 'bg-primary';

if($status == 'Kepala Sekolah'){
    $badgeClass = 'bg-danger';
}elseif($status == 'Manajemen'){
    $badgeClass = 'bg-warning text-dark';
}elseif($status == 'Tenaga Ahli'){
    $badgeClass = 'bg-info text-dark';
}elseif($status == 'Pembina'){   // ✅ TAMBAHAN
    $badgeClass = 'bg-success';
}
?>

<span class="badge <?= $badgeClass ?>">
<?= htmlspecialchars($status) ?>
</span>
</td>

<td><?= htmlspecialchars($p['bidang'] ?? '-') ?></td>
<td>
<button class="btn btn-sm btn-info" data-bs-toggle="modal" data-bs-target="#bio<?= $p['id'] ?>">
<i class="bi bi-eye"></i>
</button>

<button class="btn btn-sm btn-warning" data-bs-toggle="modal" data-bs-target="#edit<?= $p['id'] ?>">
<i class="bi bi-pencil"></i>
</button>

<a href="?hapus=<?= $p['id'] ?>" onclick="return confirm('Hapus data ini?')" class="btn btn-sm btn-danger">
<i class="bi bi-trash"></i>
</a>
</td>
</tr>

<?php 
$modalBuffer .= '
<div class="modal fade" id="edit'.$p['id'].'" tabindex="-1">
<div class="modal-dialog modal-dialog-centered">
<form method="post" enctype="multipart/form-data" class="modal-content">

<input type="hidden" name="id" value="'.$p['id'].'">
<input type="hidden" name="foto_lama" value="'.$p['foto'].'">

<div class="modal-header">
<h5 class="modal-title">Edit Profil Guru/Manajemen</h5>
<button type="button" class="btn-close" data-bs-dismiss="modal"></button>
</div>

<div class="modal-body">

<input type="text" name="nama" class="form-control" value="'.htmlspecialchars($p['nama']).'" required>
<input type="text" name="jabatan" class="form-control" value="'.htmlspecialchars($p['jabatan']).'">
<input type="text" name="tempat_lahir" class="form-control" value="'.htmlspecialchars($p['tempat_lahir']).'">
<input type="date" name="tanggal_lahir" class="form-control" value="'.$p['tanggal_lahir'].'">
<input type="text" name="nip" class="form-control" value="'.htmlspecialchars($p['nip']).'">
<input type="text" name="pendidikan" class="form-control" value="'.htmlspecialchars($p['pendidikan']).'">
<input type="text" name="alamat" class="form-control" value="'.htmlspecialchars($p['alamat']).'">
<input type="text" name="wa" class="form-control" value="'.htmlspecialchars($p['wa']).'">
<input type="email" name="email" class="form-control" value="'.htmlspecialchars($p['email']).'">
<select name="status" class="form-control">
  <option value="Guru" '.($p['status']=='Guru'?'selected':'').'>Guru</option>
  <option value="Manajemen" '.($p['status']=='Manajemen'?'selected':'').'>Manajemen</option>
  <option value="Tenaga Ahli" '.($p['status']=='Tenaga Ahli'?'selected':'').'>Tenaga Ahli</option>
  <option value="Kepala Sekolah" '.($p['status']=='Kepala Sekolah'?'selected':'').'>Kepala Sekolah</option>
  <option value="Pembina" '.($p['status']=='Pembina'?'selected':'').'>Pembina</option>
</select>

<input type="text" name="bidang" class="form-control" 
value="'.htmlspecialchars($p['bidang'] ?? '').'" 
placeholder="Bidang Keahlian">

<textarea name="keahlian" class="form-control"
placeholder="Keahlian">'.htmlspecialchars($p['keahlian'] ?? '').'</textarea>
<input type="file" name="foto" class="form-control">

</div>

<div class="modal-footer">
<button type="submit" name="edit" class="btn btn-primary">Simpan</button>
<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
</div>

</form>
</div>
</div>

';
endwhile; 
?>

</tbody>
</table>

<?= $modalBuffer ?>

</div>

<!-- Modal Tambah -->
<div class="modal fade" id="tambahModal" tabindex="-1">
<div class="modal-dialog modal-dialog-centered">
<form method="post" enctype="multipart/form-data" class="modal-content">
<div class="modal-header">
<h5 class="modal-title">Tambah Profil Guru/Manajemen</h5>
<button type="button" class="btn-close" data-bs-dismiss="modal"></button>
</div>
<div class="modal-body">
<input type="text" name="nama" class="form-control" placeholder="Nama" required>
<input type="text" name="jabatan" class="form-control" placeholder="Jabatan">
<input type="text" name="tempat_lahir" class="form-control" placeholder="Tempat Lahir">
<input type="date" name="tanggal_lahir" class="form-control" placeholder="Tanggal Lahir">
<input type="text" name="nip" class="form-control" placeholder="NIP/NUPTK">
<input type="text" name="pendidikan" class="form-control" placeholder="Pendidikan">
<input type="text" name="alamat" class="form-control" placeholder="Alamat">
<input type="text" name="wa" class="form-control" placeholder="No. Telp">
<input type="email" name="email" class="form-control" placeholder="Email">
<select name="status" class="form-control">
  <option value="Guru">Guru</option>
  <option value="Manajemen">Manajemen</option>
  <option value="Tenaga Ahli">Tenaga Ahli</option>
  <option value="Kepala Sekolah">Kepala Sekolah</option>
  <option value="Pembina">Pembina</option> <!-- ✅ TAMBAHAN -->
</select>
<input type="text" name="bidang" class="form-control" placeholder="Bidang Keahlian">

<textarea name="keahlian" class="form-control" placeholder="Keahlian"></textarea>
<input type="file" name="foto" class="form-control">
</div>
<div class="modal-footer">
<button type="submit" name="tambah" class="btn btn-primary">Simpan</button>
<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
</div>
</form>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

</body>
</html>
