<?php
session_start();
require '../config/database.php';

if (!isset($_SESSION['login']) || $_SESSION['user']['role'] != 'admin') {
    header("Location: ../auth/login.php");
    exit;
}

$page_title = 'Manajemen Kelas';

/* ================= TAMBAH ================= */
if(isset($_POST['tambah'])){
    $stmt = $conn->prepare("INSERT INTO kelas (nama_kelas,paket_id,tahun_id) VALUES (?,?,?)");
    $stmt->bind_param("sii", $_POST['nama_kelas'], $_POST['paket'], $_POST['tahun']);
    $stmt->execute();
    $stmt->close();
    header("Location: kelas.php"); exit;
}

/* ================= UPDATE ================= */
if(isset($_POST['update'])){
    $stmt = $conn->prepare("UPDATE kelas SET nama_kelas=?, paket_id=?, tahun_id=? WHERE id=?");
    $stmt->bind_param("siii", $_POST['nama_kelas'], $_POST['paket'], $_POST['tahun'], $_POST['id']);
    $stmt->execute();
    $stmt->close();
    header("Location: kelas.php"); exit;
}

/* ================= HAPUS ================= */
if(isset($_GET['hapus'])){
    $id = (int)$_GET['hapus'];
    $cek = mysqli_query($conn, "SELECT COUNT(*) as jml FROM siswa WHERE kelas_id=$id");
    $row = mysqli_fetch_assoc($cek);
    if($row['jml']==0){
        $stmt = $conn->prepare("DELETE FROM kelas WHERE id=?");
        $stmt->bind_param("i", $id);
        $stmt->execute();
        $stmt->close();
    }
    header("Location: kelas.php"); exit;
}

/* ================= DATA ================= */
$kelas = mysqli_query($conn,"
    SELECT k.*, p.nama AS nama_paket, t.tahun,
    (SELECT COUNT(*) FROM siswa s WHERE s.kelas_id=k.id) AS jml_siswa
    FROM kelas k
    JOIN paket p ON k.paket_id=p.id
    JOIN tahun_ajaran t ON k.tahun_id=t.id
    ORDER BY k.id DESC
");

$paket = mysqli_query($conn,"SELECT * FROM paket");
$tahun = mysqli_query($conn,"SELECT * FROM tahun_ajaran");
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title><?= $page_title ?></title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
<style>
body {
    background: #f4f6f9;
    font-family: 'Segoe UI', sans-serif;
    margin: 0;
}

/* Sidebar */
.sidebar-desktop {
    position: fixed;
    top: 0; left: 0;
    width: 220px; height: 100vh;
    background: #0b1c2d;
    color: #fff;
    overflow-y: auto;
}
.sidebar-desktop a {
    display: flex;
    align-items: center;
    gap: 10px;
    padding: 12px 18px;
    margin: 4px 8px;
    border-radius: 8px;
    color: #fff;
    text-decoration: none;
    font-size: 14px;
    transition: .2s;
}
.sidebar-desktop a:hover, .sidebar-desktop a.active {
    background: #1f3147;
    font-weight: 600;
}

/* Topbar */
.topbar {
    position: fixed;
    top: 0; left: 260px; right: 0;
    height: 56px;
    background: #fff;
    border-bottom: 1px solid #ddd;
    display: flex;
    align-items: center;
    padding: 0 20px;
    z-index: 1020;
}
.page-title {
    font-weight: 600;
    font-size: 1.1rem;
}

/* Main Content */
.main-content {
    margin-left: 260px; /* buat atur body laptop*/
    padding: 80px 30px 80px;
    max-width: 1100px; /* pas di laptop */
    width: 100%;
}

/* Card & Tabel */
.card {
    border-radius: 12px;
    box-shadow: 0 4px 12px rgba(0,0,0,.08);
}

.table-container {
    overflow-x: auto; /* scroll horizontal jika perlu */
}

.table th, .table td {
    text-align: center;
    vertical-align: middle;
    padding: 10px 8px;
}

.table th {
    font-weight: 600;
}

/* Kolom proporsional */
.table th:nth-child(1), .table td:nth-child(1) { width: 5%; }
.table th:nth-child(2), .table td:nth-child(2) { width: 20%; }
.table th:nth-child(3), .table td:nth-child(3) { width: 20%; }
.table th:nth-child(4), .table td:nth-child(4) { width: 15%; }
.table th:nth-child(5), .table td:nth-child(5) { width: 10%; }
.table th:nth-child(6), .table td:nth-child(6) { width: 30%; }

/* Badges & Buttons */
.badge-info {
    background: #0dcaf0;
    font-size: 0.85rem;
    padding: 4px 8px;
}
.btn-sm {
    font-size: .85rem;
    padding: .35rem .6rem;
}
.btn i { margin-right: 4px; }

/* Modal */
.modal-dialog { max-width: 600px; }

/* Footer */
footer {
    position: fixed;
    bottom: 0; left: 220px; right: 0;
    background: #fff;
    border-top: 1px solid #ddd;
    text-align: center;
    font-size: 13px;
    padding: 8px 0;
}

/* Responsive */
@media(max-width:1200px){
    .main-content { max-width: 100%; padding: 70px 15px 60px; }
}
/* ===== MOBILE ===== */
@media(max-width:991px){
 .topbar{left:0}
 .main-content{margin-left:0;padding-top:90px}
 footer{left:0}
}
</style>


</head>
<body>

<?php include __DIR__ . '/partials/sidebar.php'; ?>

<div class="topbar">
 <button class="btn btn-outline-primary d-lg-none me-2" type="button" data-bs-toggle="offcanvas" data-bs-target="#sidebarAdmin">
     <i class="bi bi-list"></i>
 </button>
 <span class="page-title"><?= $page_title ?></span>
 <span class="ms-auto small"><?= htmlspecialchars($_SESSION['user']['nama'] ?? '') ?></span>
</div>

<div class="main-content container-fluid">
<div class="d-flex justify-content-between align-items-center mb-3">
    <h5 class="mb-0"><i class="bi bi-diagram-3"></i> Data Kelas</h5>
    <button class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#modalTambah">
        <i class="bi bi-plus-circle"></i> Tambah
    </button>
</div>
<div class="card shadow-sm border-0">
  <div class="card-body table-container">
    <table class="table table-bordered table-hover table-sm align-middle">
      <thead class="table-dark">
        <tr>
          <th style="width:5%">No</th>
          <th style="width:25%">Kelas</th>
          <th style="width:20%">Paket</th>
          <th style="width:15%">Tahun</th>
          <th style="width:15%">Siswa</th>
          <th style="width:20%">Aksi</th>
        </tr>
      </thead>
      <tbody>
        <?php $no=1; while($k=mysqli_fetch_assoc($kelas)){ ?>
        <tr>
          <td><?= $no++ ?></td>
          <td><?= htmlspecialchars($k['nama_kelas']) ?></td>
          <td><?= htmlspecialchars($k['nama_paket']) ?></td>
          <td><?= htmlspecialchars($k['tahun']) ?></td>
          <td><span class="badge badge-info"><?= $k['jml_siswa'] ?></span></td>
          <td>
            <button class="btn btn-warning btn-sm edit-btn" 
                    data-id="<?= $k['id'] ?>" 
                    data-nama="<?= htmlspecialchars($k['nama_kelas']) ?>" 
                    data-paket="<?= $k['paket_id'] ?>" 
                    data-tahun="<?= $k['tahun_id'] ?>">
                    <i class="bi bi-pencil"></i> Edit
            </button>
            <?php if($k['jml_siswa']==0){ ?>
            <a href="?hapus=<?= $k['id'] ?>" onclick="return confirm('Hapus kelas ini?')" class="btn btn-danger btn-sm">
            <i class="bi bi-trash"></i> Hapus</a>
            <?php } else { ?>
            <button class="btn btn-secondary btn-sm" disabled><i class="bi bi-lock"></i> Terkunci</button>
            <?php } ?>
          </td>
        </tr>
        <?php } ?>
      </tbody>
    </table>
  </div>
</div>


<div class="modal fade" id="modalTambah">
<div class="modal-dialog">
<form method="post" class="modal-content">
<div class="modal-header bg-primary">
<h6 id="modalTitle">Tambah Kelas</h6>
<button class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
</div>
<div class="modal-body">
<input type="hidden" name="id" id="kelasId">
<input name="nama_kelas" id="namaKelas" class="form-control mb-2" placeholder="Nama Kelas" required>
<select name="paket" id="paketSelect" class="form-control mb-2">
<?php mysqli_data_seek($paket,0); while($p=mysqli_fetch_assoc($paket)){ ?>
<option value="<?= $p['id'] ?>"><?= htmlspecialchars($p['nama']) ?></option>
<?php } ?>
</select>
<select name="tahun" id="tahunSelect" class="form-control">
<?php mysqli_data_seek($tahun,0); while($t=mysqli_fetch_assoc($tahun)){ ?>
<option value="<?= $t['id'] ?>"><?= htmlspecialchars($t['tahun']) ?></option>
<?php } ?>
</select>
</div>
<div class="modal-footer">
<button class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Batal</button>
<button type="submit" name="tambah" id="submitBtn" class="btn btn-primary btn-sm">Simpan</button>
</div>
</form>
</div>

<footer>© <?= date('Y') ?> PKBM Taruna Qurani</footer>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
<script>
const editBtns = document.querySelectorAll('.edit-btn');
const modal = new bootstrap.Modal(document.getElementById('modalTambah'));
editBtns.forEach(btn=>{
    btn.addEventListener('click', ()=>{
        document.getElementById('modalTitle').textContent = 'Edit Kelas';
        document.getElementById('kelasId').value = btn.dataset.id;
        document.getElementById('namaKelas').value = btn.dataset.nama;
        document.getElementById('paketSelect').value = btn.dataset.paket;
        document.getElementById('tahunSelect').value = btn.dataset.tahun;
        document.getElementById('submitBtn').name = 'update';
        document.getElementById('submitBtn').textContent = 'Update';
        modal.show();
    });
});
</script>
</body>
</html>
