<?php
session_start();
require '../config/database.php';

if (!isset($_SESSION['login']) || $_SESSION['user']['role'] != 'admin') {
    header("Location: ../auth/login.php");
    exit;
}

/* ================= FOLDER UPLOAD ================= */
$uploadDir = "../uploads/siswa/";
if (!is_dir($uploadDir)) mkdir($uploadDir,0777,true);

/* ================= TAMBAH SISWA ================= */
if(isset($_POST['tambah'])){
    $nisn = $_POST['nisn'];
    $username = "PKBM".substr($nisn,-5)."TQ";
    $tgl = $_POST['tanggal_lahir'];
    $plainPass = $tgl ? date('dmY',strtotime($tgl)) : '123456';
    $password = password_hash($plainPass,PASSWORD_DEFAULT);

    $foto = null;
    if(!empty($_FILES['foto']['name'])){
        $ext = pathinfo($_FILES['foto']['name'],PATHINFO_EXTENSION);
        $foto = time().'_'.rand(100,999).'.'.$ext;
        move_uploaded_file($_FILES['foto']['tmp_name'],$uploadDir.$foto);
    }

    mysqli_query($conn,"INSERT INTO siswa
    (nisn,nama,tempat_lahir,tanggal_lahir,jenis_kelamin,kelas_id,wa,alamat,foto,username,password)
    VALUES(
        '$nisn',
        '$_POST[nama]',
        '$_POST[tempat_lahir]',
        '$tgl',
        '$_POST[jk]',
        '$_POST[kelas]',
        '$_POST[wa]',
        '$_POST[alamat]',
        '$foto',
        '$username',
        '$password'
    )");
    header("Location: siswa.php"); exit;
}

/* ================= EDIT SISWA ================= */
if(isset($_POST['edit'])){
    $username = "PKBM".substr($_POST['nisn'],-5)."TQ";
    $foto = $_POST['foto_lama'];
    if(!empty($_FILES['foto']['name'])){
        if($foto && file_exists($uploadDir.$foto)) unlink($uploadDir.$foto);
        $ext = pathinfo($_FILES['foto']['name'],PATHINFO_EXTENSION);
        $foto = time().'_'.rand(100,999).'.'.$ext;
        move_uploaded_file($_FILES['foto']['tmp_name'],$uploadDir.$foto);
    }

    mysqli_query($conn,"UPDATE siswa SET
        nisn='$_POST[nisn]',
        nama='$_POST[nama]',
        tempat_lahir='$_POST[tempat_lahir]',
        tanggal_lahir='$_POST[tanggal_lahir]',
        jenis_kelamin='$_POST[jk]',
        kelas_id='$_POST[kelas]',
        wa='$_POST[wa]',
        alamat='$_POST[alamat]',
        foto='$foto',
        username='$username'
        WHERE id='$_POST[id]'
    ");
    header("Location: siswa.php"); exit;
}

/* ================= RESET PASSWORD ================= */
if(isset($_POST['reset_password'])){
    $hash = password_hash($_POST['password_baru'],PASSWORD_DEFAULT);
    mysqli_query($conn,"UPDATE siswa SET password='$hash' WHERE id='$_POST[id]'");
    header("Location: siswa.php"); exit;
}

/* ================= HAPUS SISWA ================= */
if(isset($_GET['hapus'])){
    $q = mysqli_query($conn,"SELECT foto FROM siswa WHERE id='$_GET[hapus]'");
    $f = mysqli_fetch_assoc($q);
    if($f['foto'] && file_exists($uploadDir.$f['foto'])) unlink($uploadDir.$f['foto']);
    mysqli_query($conn,"DELETE FROM siswa WHERE id='$_GET[hapus]'");
    header("Location: siswa.php"); exit;
}

/* ================= DATA ================= */
$qKelas = mysqli_query($conn,"
 SELECT k.id,k.nama_kelas,p.nama AS paket
 FROM kelas k
 LEFT JOIN paket p ON k.paket_id=p.id
 ORDER BY k.nama_kelas
");

$data = mysqli_query($conn,"
 SELECT s.*,k.nama_kelas,p.nama AS paket
 FROM siswa s
 LEFT JOIN kelas k ON s.kelas_id=k.id
 LEFT JOIN paket p ON k.paket_id=p.id
 ORDER BY s.id DESC
");
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>Manajemen Siswa</title>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">

<style>
body{background:#f4f6f9;margin:0;font-family:'Segoe UI',sans-serif}

/* ===== SIDEBAR DESKTOP ===== */
.sidebar-desktop{
 position:fixed;top:0;left:0;width:260px;height:100vh;background:#0b1c2d;color:#fff;z-index:1030;overflow-y:auto;
}
.card{border-radius:16px;}
.sidebar-desktop .logo{text-align:center;padding:12px 10px}
.sidebar-desktop img{width:70px;margin-bottom:6px}
.sidebar-desktop a{
 display:flex;align-items:center;gap:10px;
 color:#fff;text-decoration:none;
 padding:10px 18px;margin:4px 10px;
 border-radius:10px;
 transition:.2s;
}
.sidebar-desktop a:hover,.sidebar-desktop a.active{background:rgba(255,255,255,.2)}

/* ===== TOPBAR ===== */
.topbar{
 position:fixed;top:0;left:260px;right:0;height:56px;
 background:#fff;border-bottom:1px solid #ddd;
 z-index:1020;display:flex;align-items:center;
 padding:0 16px;
}

/* ===== MAIN ===== */
.main-content{
 margin-left:260px;
 padding:76px 20px 70px;
 max-width:1100px;
 margin-left:auto;
 margin-right:auto;
}

/* ===== TABLE ===== */
.table img{width:40px;height:40px;object-fit:cover;border-radius:50%}

/* ===== FOOTER ===== */
footer{
 position:fixed;bottom:0;left:260px;right:0;
 max-width:1100px;margin-left:auto;margin-right:auto;
 background:#fff;border-top:1px solid #ddd;
 text-align:center;font-size:13px;padding:6px;
}

/* ===== RESPONSIVE ===== */
@media(max-width:991px){
 .sidebar-desktop{display:none}
 .topbar{left:0}
 .main-content{margin-left:0;padding:70px 12px 60px;max-width:100%}
 footer{left:0;max-width:100%}
}

/* ===== MAIN CONTENT ===== */
.main-content{
    margin-left: 260px;      /* ruang untuk sidebar */
    padding: 90px 20px 60px; /* atas: 90px supaya ada jarak dari topbar */
}
</style>
</head>
<body>

<?php include __DIR__ . '/partials/sidebar.php'; ?>

<div class="topbar">
 <button class="btn btn-outline-primary d-lg-none me-2" type="button" data-bs-toggle="offcanvas" data-bs-target="#sidebarAdmin">
     <i class="bi bi-list"></i>
 </button>
 <span class="page-title">Manajemen Siswa</span>
 <span class="ms-auto small"><?= htmlspecialchars($_SESSION['user']['nama'] ?? '') ?></span>
</div>

<div class="main-content container-fluid">

<div class="d-flex justify-content-between align-items-center mb-3">
    <h5 class="mb-0"><i class="bi bi-diagram-3"></i> Data Siswa</h5>
    <button class="btn btn-primary mb-3" data-bs-toggle="modal" data-bs-target="#modalTambah">
        <i class="bi bi-plus-circle"></i> Tambah Siswa
    </button>
</div>

<!-- MODAL TAMBAH SISWA -->
<div class="modal fade" id="modalTambah" tabindex="-1">
<div class="modal-dialog modal-lg modal-dialog-centered modal-fullscreen-md-down">
<form method="post" enctype="multipart/form-data" class="modal-content">
<div class="modal-header bg-primary text-white">
 <h5>Tambah Siswa</h5>
 <button class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
</div>
<div class="modal-body row g-2">
 <div class="col-md-6"><input name="nisn" class="form-control" placeholder="NISN" required></div>
 <div class="col-md-6"><input name="nama" class="form-control" placeholder="Nama" required></div>
 <div class="col-md-6"><input name="tempat_lahir" class="form-control" placeholder="Tempat Lahir"></div>
 <div class="col-md-6"><input type="date" name="tanggal_lahir" class="form-control"></div>
 <div class="col-md-6">
  <select name="jk" class="form-select">
   <option value="">Jenis Kelamin</option>
   <option value="L">Laki-laki</option>
   <option value="P">Perempuan</option>
  </select>
 </div>
 <div class="col-md-6">
  <select name="kelas" class="form-select" required>
   <option value="">Pilih Kelas</option>
   <?php mysqli_data_seek($qKelas,0); while($k=mysqli_fetch_assoc($qKelas)){ ?>
    <option value="<?= $k['id'] ?>"><?= $k['nama_kelas'].'-'.$k['paket'] ?></option>
   <?php } ?>
  </select>
 </div>
 <div class="col-md-6"><input name="wa" class="form-control" placeholder="No WhatsApp"></div>
 <div class="col-md-6"><input type="file" name="foto" class="form-control"></div>
 <div class="col-12"><textarea name="alamat" class="form-control" placeholder="Alamat"></textarea></div>
</div>
<div class="modal-footer">
 <button class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
 <button name="tambah" class="btn btn-primary">Simpan</button>
</div>
</form>
</div>
</div>

<div class="table-responsive">
<table class="table table-bordered table-hover align-middle small">
<thead class="table-dark text-center">
<tr>
 <th>No</th><th>Foto</th><th>NISN</th><th>Username</th><th>Nama</th><th>JK</th><th>Kelas</th><th>WA</th><th>Aksi</th>
</tr>
</thead>
<tbody>
<?php $no=1; while($s=mysqli_fetch_assoc($data)){ ?>
<tr>
 <td><?= $no++ ?></td>
 <td class="text-center"><img src="../uploads/siswa/<?= $s['foto'] ?: 'default.png' ?>" alt="Foto"></td>
 <td><?= $s['nisn'] ?></td>
 <td class="fw-bold text-primary"><?= $s['username'] ?></td>
 <td><?= $s['nama'] ?></td>
 <td><?= $s['jenis_kelamin'] ?></td>
 <td><span class="badge bg-primary"><?= $s['nama_kelas'].'-'.$s['paket'] ?></span></td>
 <td><?= $s['wa'] ?></td>
 <td class="text-center">
  <button class="btn btn-warning btn-sm" data-bs-toggle="modal" data-bs-target="#edit<?= $s['id'] ?>"><i class="bi bi-pencil"></i></button>
  <button class="btn btn-info btn-sm" data-bs-toggle="modal" data-bs-target="#pass<?= $s['id'] ?>"><i class="bi bi-key"></i></button>
  <button class="btn btn-secondary btn-sm" onclick="alert('Username: <?= $s['username'] ?>\nPassword awal: <?= $s['tanggal_lahir'] ? date('dmY',strtotime($s['tanggal_lahir'])) : '123456' ?>')"><i class="bi bi-eye"></i></button>
  <a href="?hapus=<?= $s['id'] ?>" class="btn btn-danger btn-sm" onclick="return confirm('Hapus siswa?')"><i class="bi bi-trash"></i></a>
 </td>
</tr>
<?php } ?>
</tbody>
</table>
</div>

<?php
mysqli_data_seek($data,0);
while($s=mysqli_fetch_assoc($data)){
?>
<!-- MODAL EDIT -->
<div class="modal fade" id="edit<?= $s['id'] ?>">
<div class="modal-dialog modal-lg modal-dialog-centered modal-fullscreen-md-down">
<form method="post" enctype="multipart/form-data" class="modal-content">
<input type="hidden" name="id" value="<?= $s['id'] ?>">
<input type="hidden" name="foto_lama" value="<?= $s['foto'] ?>">
<div class="modal-header bg-warning">
 <h5>Edit Siswa</h5>
 <button class="btn-close" data-bs-dismiss="modal"></button>
</div>
<div class="modal-body row g-2">
 <div class="col-md-6"><input name="nisn" value="<?= $s['nisn'] ?>" class="form-control"></div>
 <div class="col-md-6"><input name="nama" value="<?= $s['nama'] ?>" class="form-control"></div>
 <div class="col-md-6"><input name="tempat_lahir" value="<?= $s['tempat_lahir'] ?>" class="form-control"></div>
 <div class="col-md-6"><input type="date" name="tanggal_lahir" value="<?= $s['tanggal_lahir'] ?>" class="form-control"></div>
 <div class="col-md-6">
  <select name="jk" class="form-select">
   <option value="L" <?= $s['jenis_kelamin']=='L'?'selected':'' ?>>Laki-laki</option>
   <option value="P" <?= $s['jenis_kelamin']=='P'?'selected':'' ?>>Perempuan</option>
  </select>
 </div>
 <div class="col-md-6">
  <select name="kelas" class="form-select">
   <?php mysqli_data_seek($qKelas,0); while($k=mysqli_fetch_assoc($qKelas)){ ?>
    <option value="<?= $k['id'] ?>" <?= $s['kelas_id']==$k['id']?'selected':'' ?>><?= $k['nama_kelas'].'-'.$k['paket'] ?></option>
   <?php } ?>
  </select>
 </div>
 <div class="col-md-6"><input name="wa" value="<?= $s['wa'] ?>" class="form-control"></div>
 <div class="col-md-6"><input type="file" name="foto" class="form-control"></div>
 <div class="col-12"><textarea name="alamat" class="form-control"><?= $s['alamat'] ?></textarea></div>
</div>
<div class="modal-footer">
 <button class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
 <button name="edit" class="btn btn-warning">Update</button>
</div>
</form>
</div>
</div>

<!-- MODAL PASSWORD -->
<div class="modal fade" id="pass<?= $s['id'] ?>">
<div class="modal-dialog modal-lg modal-dialog-centered modal-fullscreen-md-down">
<form method="post" class="modal-content">
<input type="hidden" name="id" value="<?= $s['id'] ?>">
<div class="modal-header bg-primary text-white">
 <h5><i class="bi bi-key"></i> Reset Password</h5>
 <button class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
</div>
<div class="modal-body">
 <input name="password_baru" class="form-control" placeholder="Password baru" required>
</div>
<div class="modal-footer">
 <button class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
 <button name="reset_password" class="btn btn-primary">Simpan</button>
</div>
</form>
</div>
</div>
<?php } ?>

</div>

<footer>© <?= date('Y') ?> PKBM Taruna Qurani</footer>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
