<?php
session_start();
require '../config/database.php';

if (empty($_SESSION['login']) || ($_SESSION['user']['role'] ?? '') !== 'admin') {
    header("Location: ../auth/login.php");
    exit;
}

$aksi = $_POST['aksi'] ?? '';

$dirFoto   = '../uploads/tutor/';
$dirKtp    = '../uploads/ktp/';
$dirIjazah = '../uploads/ijazah/';

/* =============================
   FUNGSI UPLOAD FILE
============================= */
function uploadFile($field, $dir, $old = null) {
    if (empty($_FILES[$field]['name'])) return $old;

    $ext = strtolower(pathinfo($_FILES[$field]['name'], PATHINFO_EXTENSION));
    $allow = ['jpg','jpeg','png','webp','pdf'];

    if (!in_array($ext, $allow)) die('Format file tidak valid');

    if ($_FILES[$field]['size'] > 2 * 1024 * 1024) die('Ukuran file max 2MB');

    if (!is_dir($dir)) mkdir($dir, 0777, true);

    $name = $field.'_'.time().'_'.rand(100,999).'.'.$ext;
    move_uploaded_file($_FILES[$field]['tmp_name'], $dir.$name);

    if ($old && file_exists($dir.$old)) unlink($dir.$old);

    return $name;
}

/* =============================
   TAMBAH TUTOR
============================= */
if ($aksi === 'tambah') {

    $nama = mysqli_real_escape_string($conn, trim($_POST['nama']));
    $username = mysqli_real_escape_string($conn, trim($_POST['username']));
    $password0 = trim($_POST['password']);
    $pendidikan = trim($_POST['pendidikan']);
    $email = trim($_POST['email']);
    $no_hp = trim($_POST['no_hp']);

    if (strlen($password0) < 6) die('Password minimal 6 karakter');

    $cek = mysqli_query($conn, "SELECT id FROM users WHERE username='$username'");
    if (mysqli_num_rows($cek)) die('Username sudah digunakan');

    $password = password_hash($password0, PASSWORD_DEFAULT);

    mysqli_query($conn,"INSERT INTO users (nama,username,password,role)
                         VALUES ('$nama','$username','$password','tutor')");
    $user_id = mysqli_insert_id($conn);

    $foto        = uploadFile('foto', $dirFoto);
    $foto_ktp    = uploadFile('foto_ktp', $dirKtp);
    $foto_ijazah = uploadFile('foto_ijazah', $dirIjazah);

    mysqli_query($conn,"INSERT INTO tutor 
        (user_id,pendidikan,email,no_hp,foto,foto_ktp,foto_ijazah)
        VALUES 
        ('$user_id','$pendidikan','$email','$no_hp','$foto','$foto_ktp','$foto_ijazah')
    ");

    header("Location: tutor.php");
    exit;
}

/* =============================
   EDIT TUTOR
============================= */
if ($aksi === 'edit') {

    $id = (int)$_POST['id'];
    $nama = mysqli_real_escape_string($conn, trim($_POST['nama']));
    $username = mysqli_real_escape_string($conn, trim($_POST['username']));
    $password0 = trim($_POST['password']);
    $pendidikan = trim($_POST['pendidikan']);
    $email = trim($_POST['email']);
    $no_hp = trim($_POST['no_hp']);

    $q = mysqli_query($conn,"SELECT * FROM tutor WHERE id='$id'");
    $d = mysqli_fetch_assoc($q);
    if (!$d) die('Data tidak ditemukan');

    $user_id = $d['user_id'];

    $cek = mysqli_query($conn,"SELECT id FROM users WHERE username='$username' AND id!='$user_id'");
    if (mysqli_num_rows($cek)) die('Username sudah digunakan');

    $foto        = uploadFile('foto', $dirFoto, $d['foto']);
    $foto_ktp    = uploadFile('foto_ktp', $dirKtp, $d['foto_ktp']);
    $foto_ijazah = uploadFile('foto_ijazah', $dirIjazah, $d['foto_ijazah']);

    if ($password0 != '') {
        if (strlen($password0) < 6) die('Password minimal 6 karakter');
        $hash = password_hash($password0, PASSWORD_DEFAULT);
        mysqli_query($conn,"UPDATE users SET 
            nama='$nama', username='$username', password='$hash'
            WHERE id='$user_id'");
    } else {
        mysqli_query($conn,"UPDATE users SET 
            nama='$nama', username='$username'
            WHERE id='$user_id'");
    }

    mysqli_query($conn,"UPDATE tutor SET
        pendidikan='$pendidikan',
        email='$email',
        no_hp='$no_hp',
        foto='$foto',
        foto_ktp='$foto_ktp',
        foto_ijazah='$foto_ijazah'
        WHERE id='$id'
    ");

    header("Location: tutor.php");
    exit;
}

/* =============================
   HAPUS TUTOR
============================= */
if ($aksi === 'hapus') {

    $id = (int)$_POST['id'];
    $q = mysqli_query($conn,"SELECT * FROM tutor WHERE id='$id'");
    $d = mysqli_fetch_assoc($q);

    if ($d) {
        if ($d['foto'] && file_exists($dirFoto.$d['foto'])) unlink($dirFoto.$d['foto']);
        if ($d['foto_ktp'] && file_exists($dirKtp.$d['foto_ktp'])) unlink($dirKtp.$d['foto_ktp']);
        if ($d['foto_ijazah'] && file_exists($dirIjazah.$d['foto_ijazah'])) unlink($dirIjazah.$d['foto_ijazah']);

        mysqli_query($conn,"DELETE FROM tutor WHERE id='$id'");
        mysqli_query($conn,"DELETE FROM users WHERE id='{$d['user_id']}'");
    }

    header("Location: tutor.php");
    exit;
}
