<?php
session_start();
require '../config/database.php';

/* ================= PROTEKSI LOGIN ================= */
if (
    empty($_SESSION['login_siswa']) ||
    empty($_SESSION['siswa']['id'])
) {
    header("Location: login_siswa.php");
    exit;
}

$siswa_id = $_SESSION['siswa']['id'];
$nama     = $_SESSION['siswa']['nama'];
$kelas_id = $_SESSION['siswa']['kelas_id'];

/* ================= DATA SISWA + KELAS ================= */
$qs = mysqli_query($conn,"
  SELECT s.*, k.nama_kelas
  FROM siswa s
  LEFT JOIN kelas k ON k.id = s.kelas_id
  WHERE s.id = '$siswa_id'
  LIMIT 1
");
$siswa = mysqli_fetch_assoc($qs);

$nama_kelas = $siswa['nama_kelas'] ?? '-';

/* FOTO */
$foto = !empty($siswa['foto'])
        ? "../uploads/siswa/".$siswa['foto']
        : "../assets/img/user.png";

/* FORMAT KELAS */
function formatKelas($kelas){
  if(preg_match('/(\d+)\s*-\s*([A-Z])/i',$kelas,$m)){
    return "Kelas {$m[1]} Paket ".strtoupper($m[2]);
  }
  return $kelas;
}

/* ================= AMBIL DATA MATERI + STATUS BACA + ABSEN ================= */
$q = mysqli_query($conn,"
  SELECT 
    m.id,
    m.judul,
    m.tipe,
    m.file,
    m.created_at,
    mp.id AS mapel_id,
    mp.nama_mapel,
    mb.id AS sudah_dibaca,
    p.id AS sudah_absen
  FROM materi m
  JOIN mapel mp ON mp.id = m.mapel_id
  JOIN materi_kelas mk ON mk.materi_id = m.id
  LEFT JOIN materi_baca mb 
       ON mb.materi_id = m.id 
      AND mb.siswa_id = '$siswa_id'
  LEFT JOIN presensi p
       ON p.siswa_id = '$siswa_id'
      AND p.mapel_id = mp.id
      AND p.tanggal = CURDATE()
      AND p.status = 'hadir'
  WHERE mk.kelas_id = '$kelas_id'
  ORDER BY m.created_at DESC
");
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Materi Pembelajaran</title>
<meta name="viewport" content="width=device-width, initial-scale=1">

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">

<style>
body{
 background:#eef2f7;
 min-height:100vh;
 display:flex;
 flex-direction:column;
}

/* ===== HEADER PROFIL ===== */
.header-profil{
 background:linear-gradient(135deg,#0d6efd,#6610f2);
 color:white;
 border-radius:18px;
 padding:20px;
 margin-bottom:25px;
 display:flex;
 align-items:center;
 gap:15px;
}
.header-profil img{
 width:70px;
 height:70px;
 object-fit:cover;
 border-radius:50%;
 border:3px solid white;
}

/* ===== CARD MATERI ===== */
.card-materi{
 border-radius:20px;
 transition:.3s;
 height:100%;
 position:relative;
}
.card-materi:hover{
 transform:translateY(-6px);
 box-shadow:0 15px 35px rgba(0,0,0,.15);
}
.icon-materi{
 font-size:45px;
}

/* STATUS BACA */
.badge-status{
 position:absolute;
 top:12px;
 right:12px;
}


/* ===== FOOTER NAV ===== */
.footer-nav{
 position:fixed;
 bottom:0;
 left:0;
 right:0;
 background:linear-gradient(135deg,#f7e38c,#b9e4a6,#a3d9f5);
 border-top:1px solid #ddd;
 display:flex;
 justify-content:space-around;
 padding:8px 0;
 z-index:999;
}
.footer-nav a{
 text-decoration:none;
 color:#666;
 font-size:12px;
 text-align:center;
}
.footer-nav i{
 font-size:20px;
 display:block;
}
.footer-space{height:70px}
</style>
</head>
<body>

<!-- ================= NAVBAR ================= -->
<nav class="navbar navbar-dark bg-primary shadow">
 <div class="container-fluid">
  <span class="navbar-brand fw-bold">
   <i class="bi bi-mortarboard-fill"></i> PEMBELAJARAN SISWA
  </span>
 </div>
</nav>

<div class="container mt-4 mb-5">

<!-- PROFIL SISWA -->
<div class="header-profil shadow-sm">
 <img src="<?= $foto ?>">
 <div>
  <h5 class="mb-1 fw-bold"><?= htmlspecialchars($nama) ?></h5>
  <small><?= formatKelas($nama_kelas) ?></small>
 </div>
</div>

<h4 class="fw-bold mb-3">
 <i class="bi bi-book-half"></i> Daftar Materi
</h4>

<div class="row g-4">

<?php if(mysqli_num_rows($q) == 0): ?>
  <div class="col-12">
    <div class="alert alert-warning text-center shadow-sm">
      <i class="bi bi-info-circle"></i> Belum ada materi untuk kelas Anda.
    </div>
  </div>
<?php endif; ?>

<?php while($m = mysqli_fetch_assoc($q)): ?>

<?php
/* ICON & WARNA */
$icon = "bi-file-earmark-text text-secondary";
$warna = "secondary";

if($m['tipe'] == 'pdf'){ $icon="bi-file-earmark-pdf text-danger"; $warna="danger"; }
elseif($m['tipe'] == 'word'){ $icon="bi-file-earmark-word text-primary"; $warna="primary"; }
elseif($m['tipe'] == 'video'){ $icon="bi-camera-video text-success"; $warna="success"; }
elseif($m['tipe'] == 'audio'){ $icon="bi-music-note-beamed text-warning"; $warna="warning"; }
elseif($m['tipe'] == 'youtube'){ $icon="bi-youtube text-danger"; $warna="danger"; }

$sudah_baca  = !empty($m['sudah_dibaca']);
$sudah_absen = !empty($m['sudah_absen']);
?>

<div class="col-xl-3 col-lg-4 col-md-6 col-12">

 <div class="card card-materi shadow-sm p-3">

  <!-- BADGE STATUS -->
  <?php if($sudah_baca): ?>
    <span class="badge bg-success badge-status">
      <i class="bi bi-check-circle"></i> Dibaca
    </span>
  <?php else: ?>
    <span class="badge bg-warning text-dark badge-status">
      <i class="bi bi-clock"></i> Belum
    </span>
  <?php endif; ?>

  <div class="text-center mb-3">
    <i class="bi <?= $icon ?> icon-materi"></i>
  </div>

  <h6 class="fw-bold"><?= htmlspecialchars($m['judul']) ?></h6>
  <small class="text-muted d-block mb-2">
    <?= htmlspecialchars($m['nama_mapel']) ?>
  </small>

  <small class="text-muted">
    <i class="bi bi-calendar"></i> 
    <?= date('d M Y', strtotime($m['created_at'])) ?>
  </small>

  <div class="mt-3 d-grid">
    <?php if($sudah_absen): ?>
      <a href="materi_view.php?id=<?= $m['id'] ?>" 
         class="btn btn-<?= $warna ?> btn-sm rounded-pill">
        <i class="bi bi-eye"></i> Buka Materi
      </a>
    <?php else: ?>
      <a href="absen.php?mapel_id=<?= $m['mapel_id'] ?>" 
         class="btn btn-secondary btn-sm rounded-pill">
        <i class="bi bi-geo-alt"></i> Absen Dulu
      </a>
    <?php endif; ?>
  </div>

 </div>

</div>

<?php endwhile; ?>

</div>
</div>

<!-- ================= FOOTER ================= -->
<div class="footer-nav">
 <a href="dashboard.php"><i class="bi bi-house"></i>Home</a>
 <a href="absen_list.php"><i class="bi bi-camera"></i>Absen</a>
 <a href="materi.php"><i class="bi bi-book"></i>Materi</a>
 <a href="elearning.php"><i class="bi bi-laptop"></i>E-Learning</a>
 <a href="#"><i class="bi bi-journal-check"></i>Ujian</a>
</div>

<div class="footer-space"></div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
