<?php
session_start();
require '../config/database.php';

/* ================= PROTEKSI LOGIN ================= */
if (
 empty($_SESSION['login_siswa']) ||
 empty($_SESSION['siswa']['id'])
) {
 header("Location: login_siswa.php");
 exit;
}

$siswa_id  = $_SESSION['siswa']['id'];
$materi_id = intval($_GET['materi_id'] ?? 0);

if($materi_id == 0){
 die("Materi tidak valid");
}

/* ================= CEK SUDAH BACA MATERI ================= */
$cek = mysqli_query($conn,"
 SELECT id FROM materi_baca
 WHERE siswa_id='$siswa_id'
   AND materi_id='$materi_id'
 LIMIT 1
");

if(mysqli_num_rows($cek) == 0){
 echo "<script>
   alert('Anda harus membaca materi terlebih dahulu!');
   location='elearning.php';
 </script>";
 exit;
}

/* ================= TOTAL SOAL ================= */
$q_total = mysqli_query($conn,"
 SELECT COUNT(*) total
 FROM materi_soal
 WHERE materi_id='$materi_id'
");
$total_soal = mysqli_fetch_assoc($q_total)['total'] ?? 0;

/* ================= TOTAL JAWABAN SISWA ================= */
$q_jawab = mysqli_query($conn,"
 SELECT COUNT(DISTINCT soal_id) total
 FROM materi_jawaban_siswa
 WHERE siswa_id='$siswa_id'
   AND materi_id='$materi_id'
");
$total_jawab = mysqli_fetch_assoc($q_jawab)['total'] ?? 0;

/* ================= STATUS SELESAI ================= */
$selesai = ($total_soal > 0 && $total_jawab >= $total_soal);

/* ================= AMBIL DATA SOAL ================= */
$q = mysqli_query($conn,"
 SELECT * FROM materi_soal
 WHERE materi_id='$materi_id'
 ORDER BY urutan ASC, id ASC
");

if(mysqli_num_rows($q) == 0){
 die("Belum ada soal untuk materi ini.");
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Latihan Soal</title>
<meta name="viewport" content="width=device-width, initial-scale=1">

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">

<style>
body{
 background:#eef2f7;
 min-height:100vh;
 display:flex;
 flex-direction:column;
}
.card-soal{border-radius:16px}
.footer-space{margin-top:auto}
</style>
</head>
<body>

<!-- ================= NAVBAR ================= -->
<nav class="navbar navbar-dark bg-primary shadow-sm">
 <div class="container-fluid">

  <span class="navbar-brand fw-bold">
   <i class="bi bi-pencil-square"></i> Latihan Soal
  </span>

  <?php if($selesai): ?>
  <a href="elearning.php" class="btn btn-light btn-sm">
   <i class="bi bi-arrow-left-circle"></i> Kembali
  </a>
  <?php endif; ?>

 </div>
</nav>

<div class="container py-4">

<div class="alert <?= $selesai ? 'alert-success' : 'alert-warning' ?> shadow-sm">
 <b>Status:</b>
 <?= $selesai
   ? "Semua soal sudah dijawab. Silakan kembali ke E-Learning."
   : "Jawab semua soal lalu simpan untuk membuka tombol kembali." ?>
</div>

<?php if(!$selesai): ?>

<form action="soal_simpan.php" method="POST">
<input type="hidden" name="materi_id" value="<?= $materi_id ?>">

<?php $no=1; while($s = mysqli_fetch_assoc($q)): ?>

<?php
$qo = mysqli_query($conn,"
 SELECT * FROM materi_soal_opsi
 WHERE soal_id='{$s['id']}'
 ORDER BY id ASC
");

$huruf = ['A','B','C','D','E'];
$i = 0;
?>

<div class="card card-soal shadow-sm mb-3">
 <div class="card-body">

  <b><?= $no++ ?>. <?= htmlspecialchars($s['pertanyaan']) ?></b>

  <div class="mt-3">

  <?php if($s['tipe'] == 'pg'): ?>

   <?php while($o = mysqli_fetch_assoc($qo)): ?>
<div class="form-check mb-1">
 <input class="form-check-input" type="radio"
        name="jawaban[<?= $s['id'] ?>]"
        value="<?= htmlspecialchars($o['opsi']) ?>"
        required>
 <label class="form-check-label">
  <?= $huruf[$i] ?>. <?= htmlspecialchars($o['opsi']) ?>
 </label>
</div>
<?php $i++; endwhile; ?>

  <?php elseif($s['tipe'] == 'bs'): ?>

   <div class="form-check">
    <input class="form-check-input" type="radio"
           name="jawaban[<?= $s['id'] ?>]"
           value="benar" required>
    <label class="form-check-label">Benar</label>
   </div>
   <div class="form-check">
    <input class="form-check-input" type="radio"
           name="jawaban[<?= $s['id'] ?>]"
           value="salah" required>
    <label class="form-check-label">Salah</label>
   </div>

  <?php elseif($s['tipe'] == 'isian'): ?>

   <input type="text"
          name="jawaban[<?= $s['id'] ?>]"
          class="form-control mt-2"
          required>

  <?php else: ?>

   <textarea name="jawaban[<?= $s['id'] ?>]"
             class="form-control mt-2"
             rows="4"
             required></textarea>

  <?php endif; ?>

  </div>
 </div>
</div>

<?php endwhile; ?>

<button class="btn btn-success w-100 mt-3">
 <i class="bi bi-check-circle"></i> Simpan Jawaban
</button>

</form>

<?php endif; ?>

</div>

<!-- ================= FOOTER ================= -->
<div class="footer-space">
<?php include 'footer.php'; ?>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
