<?php
session_start();
require '../config/database.php';

if (empty($_SESSION['login']) || ($_SESSION['user']['role'] ?? '') !== 'tutor') {
    die('Akses ditolak');
}

$tutor_id = (int)$_SESSION['user']['id'];
$kelas_id = (int)($_GET['kelas_id'] ?? 0);
$mapel_id = (int)($_GET['mapel_id'] ?? 0);

$tgl_awal  = $_GET['tgl_awal'] ?? date('Y-m-d');
$tgl_akhir = $_GET['tgl_akhir'] ?? $tgl_awal;

/* ===== INFO ===== */
$qInfo = mysqli_query($conn,"
 SELECT k.nama_kelas, p.nama AS paket, mp.nama_mapel
 FROM kelas_mengajar km
 JOIN kelas k ON k.id=km.kelas_id
 JOIN mapel mp ON mp.id=km.mapel_id
 LEFT JOIN paket p ON p.id=k.paket_id
 WHERE km.tutor_id=$tutor_id
   AND km.kelas_id=$kelas_id
   AND km.mapel_id=$mapel_id
 LIMIT 1
");

$info = mysqli_fetch_assoc($qInfo) ?: [
 'nama_kelas'=>'-','paket'=>'','nama_mapel'=>'-'
];

/* ===== DATA REKAP (FIX HARIAN / MINGGUAN / BULANAN) ===== */
$q = mysqli_query($conn,"
 SELECT 
   s.id,
   s.nama,

   COUNT(DISTINCT CASE WHEN pr.status='hadir' THEN pr.tanggal END) AS hadir,
   COUNT(DISTINCT CASE WHEN pr.status='izin'  THEN pr.tanggal END) AS izin,
   COUNT(DISTINCT CASE WHEN pr.status='sakit' THEN pr.tanggal END) AS sakit,
   COUNT(DISTINCT CASE WHEN pr.status IN ('alfa','alpa') THEN pr.tanggal END) AS alpa,

   COUNT(DISTINCT pr.tanggal) AS total
 FROM siswa s
 LEFT JOIN presensi pr 
   ON pr.siswa_id=s.id
  AND pr.mapel_id=$mapel_id
  AND pr.tanggal BETWEEN '$tgl_awal' AND '$tgl_akhir'
 WHERE s.kelas_id=$kelas_id
 GROUP BY s.id
 ORDER BY s.nama
");
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Cetak Absensi</title>

<style>
body{
 font-family:Arial,Helvetica,sans-serif;
 font-size:12px;
 color:#000;
 -webkit-print-color-adjust:exact !important;
 print-color-adjust:exact !important;
}

.header{text-align:center}
.header h2{margin:0}

/* HILANGKAN GARIS KOTAK INFO */
.info,
.info tr,
.info td{
 border:none !important;
}


table{
 width:100%;
 border-collapse:collapse;
 margin-top:15px;
}
th,td{
 border:1px solid #000;
 padding:6px;
}
th{
 background:#f2f2f2;
 text-align:center;
}

.center{text-align:center}
.left{text-align:left}

.hadir{background:#c6efce}
.izin{background:#fff2cc}
.sakit{background:#ddebf7}
.alpa{background:#f8cbad}

@media print{
 .noprint{display:none!important}
 @page{
  margin:15mm;
 }
}
</style>
</head>

<body>

<div class="header">
 <h2>PKBM TARUNA QURANI</h2>
 <div><b>REKAP ABSENSI SISWA</b></div>
 <hr>
</div>

<!-- INFO VERTIKAL -->
<table class="info">
<tr>
 <td width="120"><b>Kelas</b></td>
 <td>: <?= $info['nama_kelas'] ?><?= $info['paket']?'-'.$info['paket']:'' ?></td>
</tr>
<tr>
 <td><b>Mapel</b></td>
 <td>: <?= $info['nama_mapel'] ?></td>
</tr>
<tr>
 <td><b>Periode</b></td>
 <td>: <?= date('d-m-Y',strtotime($tgl_awal)) ?> s/d <?= date('d-m-Y',strtotime($tgl_akhir)) ?></td>
</tr>
</table>

<table>
<thead>
<tr>
 <th>No</th>
 <th>Nama Siswa</th>
 <th>H</th>
 <th>I</th>
 <th>S</th>
 <th>A</th>
 <th>Total</th>
 <th>% Hadir</th>
 <th>Keterangan</th>
</tr>
</thead>
<tbody>
<?php
$no=1;
if(mysqli_num_rows($q)==0){
 echo "<tr><td colspan='9' class='center'>Tidak ada data</td></tr>";
}

while($r=mysqli_fetch_assoc($q)){
 $H=(int)$r['hadir'];
 $I=(int)$r['izin'];
 $S=(int)$r['sakit'];
 $A=(int)$r['alpa'];
 $T=max(1,(int)$r['total']);

 $persen = round(($H/$T)*100);

 $ket = match(true){
  $persen>=90=>'Sangat Aktif',
  $persen>=75=>'Aktif',
  $persen>=60=>'Cukup',
  default=>'Kurang Aktif'
 };
?>
<tr>
 <td class="center"><?= $no++ ?></td>
 <td class="left"><?= htmlspecialchars($r['nama']) ?></td>
 <td class="center hadir"><?= $H ?></td>
 <td class="center izin"><?= $I ?></td>
 <td class="center sakit"><?= $S ?></td>
 <td class="center alpa"><?= $A ?></td>
 <td class="center"><?= $T ?></td>
 <td class="center"><?= $persen ?>%</td>
 <td class="center"><?= $ket ?></td>
</tr>
<?php } ?>
</tbody>
</table>

<br><br>

<div style="width:250px;float:right;text-align:center">
Tutor<br><br><br>
________________________
</div>

<div class="noprint">
 <button onclick="window.print()">Print</button>
</div>

<?php if(isset($_GET['auto'])) echo "<script>window.print()</script>"; ?>

</body>
</html>
