<?php
session_start();
require '../config/database.php';
require '../vendor/autoload.php';

use Dompdf\Dompdf;
use Dompdf\Options;

/* ================= PROTEKSI ================= */
if (empty($_SESSION['login']) || ($_SESSION['user']['role'] ?? '') !== 'tutor') {
    die('Akses ditolak');
}

$tutor_id = (int)$_SESSION['user']['id'];
$kelas_id = (int)($_GET['kelas_id'] ?? 0);
$mapel_id = (int)($_GET['mapel_id'] ?? 0);
$tgl_awal = $_GET['tgl_awal'] ?? date('Y-m-d');
$tgl_akhir = $_GET['tgl_akhir'] ?? $tgl_awal;

/* ================= INFO KELAS ================= */
$qInfo = mysqli_query($conn,"
 SELECT k.nama_kelas, p.nama AS paket, mp.nama_mapel
 FROM kelas_mengajar km
 JOIN kelas k ON k.id=km.kelas_id
 JOIN mapel mp ON mp.id=km.mapel_id
 LEFT JOIN paket p ON p.id=k.paket_id
 WHERE km.tutor_id=$tutor_id
   AND km.kelas_id=$kelas_id
   AND km.mapel_id=$mapel_id
 LIMIT 1
");

$info = mysqli_fetch_assoc($qInfo);

/* ================= DATA ABSENSI ================= */
$q = mysqli_query($conn,"
 SELECT 
   s.nama,
   SUM(pr.status='hadir') AS hadir,
   SUM(pr.status='izin') AS izin,
   SUM(pr.status='sakit') AS sakit,
   SUM(pr.status IN ('alfa','alpa')) AS alpa,
   COUNT(pr.id) AS total
 FROM siswa s
 LEFT JOIN presensi pr
   ON pr.siswa_id=s.id
  AND pr.mapel_id=$mapel_id
  AND pr.tanggal BETWEEN '$tgl_awal' AND '$tgl_akhir'
 WHERE s.kelas_id=$kelas_id
 GROUP BY s.id
 ORDER BY s.nama
");

/* ================= HTML PDF ================= */
$html = '
<style>
body{font-family:DejaVu Sans;font-size:11px}
h2{text-align:center;margin:0}
table{width:100%;border-collapse:collapse;margin-top:10px}
th,td{border:1px solid #000;padding:5px;text-align:center}
th{background:#f2f2f2}
.left{text-align:left}
.h{background:#c6efce}
.i{background:#fff2cc}
.s{background:#ddebf7}
.a{background:#f8cbad}
.info td{border:none;padding:2px}
.info{
  margin-top:8px;
  margin-bottom:10px;
}

.info td{
  border:none !important;
  padding:2px 4px;
  font-size:11px;
}

.info .label{
  width:60px;
  text-align:left;
}

.info .colon{
  width:8px;
  text-align:center;
}

.info .value{
  text-align:left;
}

</style>

<h2>PKBM TARUNA QURANI</h2>
<div style="text-align:center;margin-bottom:5px">
Rekap Absensi Siswa
</div>

<table class="info">
  <tr>
    <td class="label">Kelas</td>
    <td class="colon">:</td>
    <td class="value">'.$info['nama_kelas'].($info['paket'] ? ' - '.$info['paket'] : '').'</td>
  </tr>
  <tr>
    <td class="label">Mapel</td>
    <td class="colon">:</td>
    <td class="value">'.$info['nama_mapel'].'</td>
  </tr>
  <tr>
    <td class="label">Periode</td>
    <td class="colon">:</td>
    <td class="value">'.date('d-m-Y',strtotime($tgl_awal)).' s/d '.date('d-m-Y',strtotime($tgl_akhir)).'</td>
  </tr>
</table>


<table>
<tr>
<th>No</th>
<th>Nama</th>
<th>H</th>
<th>I</th>
<th>S</th>
<th>A</th>
<th>Total</th>
<th>%</th>
<th>Keterangan</th>
</tr>
';

$no=1;
while($r=mysqli_fetch_assoc($q)){
 $total = max(1,$r['total']);
 $persen = round(($r['hadir']/$total)*100);
 $ket = $persen>=90?'Sangat Aktif':($persen>=75?'Aktif':($persen>=60?'Cukup':'Kurang'));
 $html .= "
 <tr>
  <td>$no</td>
  <td class='left'>{$r['nama']}</td>
  <td class='h'>{$r['hadir']}</td>
  <td class='i'>{$r['izin']}</td>
  <td class='s'>{$r['sakit']}</td>
  <td class='a'>{$r['alpa']}</td>
  <td>$total</td>
  <td>{$persen}%</td>
  <td>$ket</td>
 </tr>";
 $no++;
}

$html .= '</table>';

/* ================= GENERATE PDF ================= */
$options = new Options();
$options->set('defaultFont','DejaVu Sans');
$dompdf = new Dompdf($options);
$dompdf->loadHtml($html);
$dompdf->setPaper('A4','portrait');
$dompdf->render();
$dompdf->stream("Absensi.pdf",["Attachment"=>false]);
