<?php
session_start();
require '../config/database.php';

/* ================= AUTH TUTOR ================= */
if (!isset($_SESSION['login']) || $_SESSION['user']['role'] !== 'tutor') {
    header("Location: ../auth/login.php");
    exit;
}

/* =====================
   TAMBAH / EDIT
===================== */
if (isset($_POST['simpan'])) {

    $judul     = mysqli_real_escape_string($conn, $_POST['judul']);
    $jenis     = $_POST['jenis'];
    $deskripsi = mysqli_real_escape_string($conn, $_POST['deskripsi']);

    // KUNCI KATEGORI
    $kategori = 'siswa';

    $folder = __DIR__ . "/ebook_file/$jenis";
    if (!is_dir($folder)) mkdir($folder, 0777, true);

    if ($_POST['aksi'] === 'tambah') {

        if (!empty($_FILES['file']['name'])) {

            $ext  = pathinfo($_FILES['file']['name'], PATHINFO_EXTENSION);
            $file = time().'_'.rand(100,999).'.'.$ext;
            $target = "$folder/$file";

            if (!move_uploaded_file($_FILES['file']['tmp_name'], $target)) {
                die("Upload gagal");
            }

            mysqli_query($conn,"INSERT INTO ebook 
                (judul,kategori,jenis,file,deskripsi) 
                VALUES 
                ('$judul','$kategori','$jenis','$file','$deskripsi')");

        } else {
            die("File wajib diupload");
        }

    } else {

        $id = (int)$_POST['id'];
        $qfile = "";

        if (!empty($_FILES['file']['name'])) {
            $ext  = pathinfo($_FILES['file']['name'], PATHINFO_EXTENSION);
            $file = time().'_'.rand(100,999).'.'.$ext;
            $target = "$folder/$file";

            if (!move_uploaded_file($_FILES['file']['tmp_name'], $target)) {
                die("Upload gagal");
            }

            $qfile = ", file='$file'";
        }

        mysqli_query($conn,"UPDATE ebook SET 
            judul='$judul',
            jenis='$jenis',
            deskripsi='$deskripsi',
            kategori='siswa'
            $qfile
            WHERE id='$id'");
    }

    header("Location: ebook_tutor.php");
    exit;
}

/* =====================
   HAPUS
===================== */
if (isset($_GET['hapus'])) {

    $id = (int)$_GET['hapus'];

    $q = mysqli_query($conn,"SELECT * FROM ebook WHERE id='$id'");
    $d = mysqli_fetch_assoc($q);

    if ($d) {
        $file = __DIR__."/ebook_file/{$d['jenis']}/{$d['file']}";
        if (is_file($file)) unlink($file);

        mysqli_query($conn,"DELETE FROM ebook WHERE id='$id'");
    }

    header("Location: ebook_tutor.php");
    exit;
}

/* ================= DATA ================= */
$data = mysqli_query($conn,"
    SELECT * FROM ebook 
    WHERE kategori='siswa'
    ORDER BY id DESC
");
?>

<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>E-Book Siswa - Tutor</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
<style>
body{ background:#f5f7fa; margin:0; padding-top:60px; }
.sidebar{ width:260px; position:fixed; top:0; left:0; height:100vh; background:#fff; border-right:1px solid #ddd; z-index:1030; }
.topbar{ position:fixed; top:0; left:260px; right:0; height:56px; background:#fff; border-bottom:1px solid #ddd; display:flex; align-items:center; padding:0 16px; z-index:1020; }
.main-content{ margin-left:260px; padding:20px; }
@media(max-width:991px){
    .sidebar{ transform:translateX(-100%); transition:.3s; }
    .sidebar.show{ transform:translateX(0); }
    .topbar{ left:0; }
    .main-content{ margin-left:0; }
}
.table td,.table th{ vertical-align:middle }
</style>
</head>
<body>

<?php include __DIR__ . '/sidebar.php'; ?>

<div class="topbar">
    <span class="fw-semibold">📘 E-Book Siswa (Tutor)</span>
</div>

<div class="main-content">

<div class="d-flex justify-content-between align-items-center mb-3">
<h4 class="fw-bold mb-0">Manajemen E-Book Siswa</h4>
<button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#modalForm" onclick="resetForm()">
<i class="bi bi-plus"></i> Tambah
</button>
</div>

<div class="card shadow-sm border-0">
<div class="card-body table-responsive">

<table class="table table-hover">
<thead class="table-dark text-center">
<tr>
<th width="40">No</th>
<th>Judul</th>
<th>Jenis</th>
<th>File</th>
<th width="120">Aksi</th>
</tr>
</thead>
<tbody>

<?php if(mysqli_num_rows($data)==0): ?>
<tr>
<td colspan="5" class="text-center text-muted py-4">
<i class="bi bi-inbox fs-2"></i><br>
Belum ada E-Book Siswa
</td>
</tr>
<?php else: $no=1; while($r=mysqli_fetch_assoc($data)): ?>
<tr>
<td class="text-center"><?= $no++ ?></td>
<td><?= htmlspecialchars($r['judul']) ?></td>
<td class="text-center"><span class="badge bg-info"><?= strtoupper($r['jenis']) ?></span></td>
<td class="text-center">
<a href="ebook_file/<?= $r['jenis'] ?>/<?= $r['file'] ?>" target="_blank" class="btn btn-success btn-sm">
<i class="bi bi-eye"></i>
</a>
</td>
<td class="text-center">
<button class="btn btn-warning btn-sm" onclick='editData(<?= json_encode($r) ?>)' data-bs-toggle="modal" data-bs-target="#modalForm">
<i class="bi bi-pencil"></i></button>
<a href="?hapus=<?= $r['id'] ?>" onclick="return confirm('Hapus E-Book?')" class="btn btn-danger btn-sm">
<i class="bi bi-trash"></i></a>
</td>
</tr>
<?php endwhile; endif; ?>

</tbody>
</table>

</div>
</div>

</div>

<!-- MODAL -->
<div class="modal fade" id="modalForm">
<div class="modal-dialog modal-dialog-centered">
<form method="post" enctype="multipart/form-data">
<div class="modal-content">

<div class="modal-header">
<h5 id="modalTitle">Tambah E-Book</h5>
<button class="btn-close" data-bs-dismiss="modal"></button>
</div>

<div class="modal-body">
<input type="hidden" name="id" id="id">
<input type="hidden" name="aksi" id="aksi" value="tambah">

<input class="form-control mb-2" name="judul" id="judul" placeholder="Judul" required>

<select name="jenis" id="jenis" class="form-control mb-2" required>
<option value="">-- Jenis --</option>
<option value="pdf">PDF</option>
<option value="video">Video</option>
<option value="word">Word</option>
</select>

<textarea name="deskripsi" id="deskripsi" class="form-control mb-2" placeholder="Deskripsi"></textarea>

<input type="file" name="file" class="form-control">
</div>

<div class="modal-footer">
<button class="btn btn-primary" name="simpan">Simpan</button>
</div>

</div>
</form>
</div>
</div>

<script>
function resetForm(){
 document.getElementById('modalTitle').innerText='Tambah E-Book';
 document.getElementById('aksi').value='tambah';
 document.querySelector('#modalForm form').reset();
}

function editData(d){
 document.getElementById('modalTitle').innerText='Edit E-Book';
 document.getElementById('aksi').value='edit';
 document.getElementById('id').value=d.id;
 document.getElementById('judul').value=d.judul;
 document.getElementById('jenis').value=d.jenis;
 document.getElementById('deskripsi').value=d.deskripsi;
}
</script>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
