<?php
session_start();
require '../config/database.php';

/* ================= PROTEKSI ================= */
if (
    empty($_SESSION['login']) ||
    ($_SESSION['user']['role'] ?? '') !== 'tutor'
) {
    header("Location: ../auth/login.php");
    exit;
}

$tutor_id = $_SESSION['user']['id'];

/* ================= FILTER ================= */
$kelas_id = $_GET['kelas_id'] ?? '';
$mapel_id = $_GET['mapel_id'] ?? '';

$where = "WHERE m.tutor_id = '$tutor_id'";
if($kelas_id) $where .= " AND k.id = '$kelas_id'";
if($mapel_id) $where .= " AND mp.id = '$mapel_id'";

/* ================= DATA DROPDOWN ================= */
$qKelas = mysqli_query($conn,"
 SELECT DISTINCT k.id, CONCAT(k.nama_kelas,'-',p.nama) AS nama_kelas
 FROM kelas k
 LEFT JOIN paket p ON p.id = k.paket_id
 JOIN kelas_mengajar km ON km.kelas_id = k.id
 WHERE km.tutor_id = '$tutor_id'
 ORDER BY k.nama_kelas, p.nama
");

$qMapel = mysqli_query($conn,"
 SELECT DISTINCT mp.id, mp.nama_mapel
 FROM mapel mp
 JOIN kelas_mengajar km ON km.mapel_id = mp.id
 WHERE km.tutor_id = '$tutor_id'
 ORDER BY mp.nama_mapel
");

/* ================= DATA REKAP ================= */
$q = mysqli_query($conn,"
 SELECT 
   s.id AS siswa_id,
   s.nama AS nama_siswa,
   CONCAT(k.nama_kelas,'-',IFNULL(p.nama,'')) AS kelas_label,
   mp.nama_mapel,
   m.id AS materi_id,
   m.judul AS judul_materi,
   COUNT(mjs.id) AS jumlah_soal,
   MIN(mjs.dijawab_pada) AS mulai,
   MAX(mjs.dijawab_pada) AS selesai,
   SUM(mjs.benar) AS total_benar
 FROM materi_jawaban_siswa mjs
 JOIN siswa s ON s.id = mjs.siswa_id
 JOIN kelas k ON k.id = s.kelas_id
 LEFT JOIN paket p ON p.id = k.paket_id
 JOIN materi m ON m.id = mjs.materi_id
 JOIN mapel mp ON mp.id = m.mapel_id
 $where
 GROUP BY s.id, m.id
 ORDER BY selesai DESC
");

?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Jawaban Siswa</title>
<meta name="viewport" content="width=device-width, initial-scale=1">

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">

<style>
body{
 background:#eef2f7;
 font-size:14px;
}

.main-wrapper{
 padding:20px;
 padding-left:260px;
}

@media(max-width:992px){
 .main-wrapper{padding-left:0}
}

.card{
 border-radius:12px;
}

.table td,.table th{
 vertical-align:middle;
 white-space:nowrap;
}

.filter-box label{
 font-size:12px;
 font-weight:600;
 margin-bottom:2px;
}

/******** MOBILE CARD ********/
.mobile-card{
 display:none;
}

@media(max-width:768px){
 .desktop-table{
   display:none;
 }
 .mobile-card{
   display:block;
 }
 .mobile-card .card{
   border-radius:10px;
   margin-bottom:10px;
 }
 .mobile-header{
   font-weight:600;
   font-size:15px;
 }
 .mobile-details{
   font-size:13px;
   padding-left:5px;
 }
}
/* ===== FOOTER MOBILE MENU ===== */
.footer-mobile{
 display:none;
}

@media(max-width:991px){
 .footer-mobile{
  display:flex;
  position:fixed;
  bottom:0;
  left:0;
  right:0;
  background:#fff;
  border-top:1px solid #ddd;
  z-index:999;
 }

 .footer-mobile a{
  flex:1;
  text-align:center;
  padding:8px 4px;
  font-size:11px;
  color:#666;
  text-decoration:none;
 }

 .footer-mobile a i{
  font-size:18px;
  display:block;
 }

 .footer-mobile a.active{
  color:#0d6efd;
  font-weight:600;
 }

 .footer-mobile a.active i{
  color:#0d6efd;
 }

 /* kasih ruang supaya konten ga ketutup footer */
 body{padding-bottom:65px}
}

</style>
</head>
<!-- FOOTER MOBILE -->
<div class="footer-mobile d-lg-none">

 <a href="dashboard.php" class="active">
  <i class="bi bi-person-circle"></i>
  Profil
 </a>

 <a href="absen_list_cetak.php">
  <i class="bi bi-clipboard-check"></i>
  Absen
 </a>

 <a href="materi.php">
  <i class="bi bi-journal-text"></i>
  Materi
 </a>

 <a href="elearning.php">
  <i class="bi bi-laptop"></i>
  E-Learning
 </a>

 <a href="absen_dan_jawaban.php">
  <i class="bi bi-ui-checks-grid"></i>
  Jawaban
 </a>

</div>

<body>

<div class="d-lg-none sticky-top bg-primary text-white px-3 py-2 d-flex align-items-center gap-2">
    <button class="btn btn-light btn-sm"
        data-bs-toggle="offcanvas"
        data-bs-target="#sidebarTutor">
        <i class="bi bi-list"></i>
    </button>
    <strong class="mb-0">Jawaban Siswa</strong>
</div>

<?php include 'sidebar.php'; ?>

<div class="main-wrapper">

<!-- ================= FILTER ================= -->
<div class="card shadow-sm mb-3">
 <div class="card-body">
  <form method="GET" class="row g-2 filter-box">

   <div class="col-md-4">
    <label>Kelas</label>
    <select name="kelas_id" class="form-select form-select-sm">
     <option value="">Semua</option>
     <?php while($k=mysqli_fetch_assoc($qKelas)){ ?>
      <option value="<?= $k['id'] ?>" <?= $kelas_id==$k['id']?'selected':'' ?>>
        <?= $k['nama_kelas'] ?>
      </option>
     <?php } ?>
    </select>
   </div>

   <div class="col-md-4">
    <label>Mapel</label>
    <select name="mapel_id" class="form-select form-select-sm">
     <option value="">Semua</option>
     <?php while($m=mysqli_fetch_assoc($qMapel)){ ?>
      <option value="<?= $m['id'] ?>" <?= $mapel_id==$m['id']?'selected':'' ?>>
        <?= $m['nama_mapel'] ?>
      </option>
     <?php } ?>
    </select>
   </div>

   <div class="col-md-4 d-flex align-items-end">
    <button class="btn btn-primary btn-sm w-100"><i class="bi bi-funnel"></i> Filter</button>
   </div>

  </form>
 </div>
</div>

<!-- ================= TABEL DESKTOP ================= -->
<div class="card shadow-sm">
 <div class="card-header bg-primary text-white">
  <i class="bi bi-ui-checks"></i> Rekap Jawaban Siswa
 </div>

 <div class="card-body desktop-table table-responsive">
  <table class="table table-bordered table-striped">
   <thead class="table-light text-center">
    <tr>
     <th>No</th>
     <th>Siswa</th>
     <th>Kelas</th>
     <th>Mapel</th>
     <th>Materi</th>
     <th>Soal</th>
     <th>Waktu</th>
     <th>Aksi</th>
    </tr>
   </thead>
   <tbody>
   <?php if(mysqli_num_rows($q)==0){ ?>
    <tr><td colspan="8" class="text-center text-muted py-2">Tidak ada data</td></tr>
   <?php } else {
    $no=1;
    while($r=mysqli_fetch_assoc($q)){
   ?>
    <tr>
     <td class="text-center"><?= $no++ ?></td>
     <td><?= $r['nama_siswa'] ?></td>
     <td class="text-center"><?= $r['kelas_label'] ?></td>
     <td><?= $r['nama_mapel'] ?></td>
     <td><?= $r['judul_materi'] ?></td>
     <td class="text-center"><?= $r['jumlah_soal'] ?></td>
     <td class="text-center">
      <?= date('d-m-Y H:i', strtotime($r['mulai'])) ?> -
      <?= date('H:i', strtotime($r['selesai'])) ?>
     </td>
     <td class="text-center">
      <a href="absen_dan_jawaban.php?s=<?= $r['siswa_id'] ?>&m=<?= $r['materi_id'] ?>" class="btn btn-info btn-sm">Lihat</a>
      <a href="cetak_nilai_siswa.php?s=<?= (int)$r['siswa_id'] ?>&m=<?= (int)$r['materi_id'] ?>"
   class="btn btn-success btn-sm"
   target="_blank">
   <i class="bi bi-printer"></i> Nilai
</a>

     </td>
    </tr>
   <?php }} ?>
   </tbody>
  </table>
 </div>

<!-- ================= MOBILE CARD ================= -->
 <div class="mobile-card p-2">
<?php
if(mysqli_num_rows($q)==0){
 echo '<div class="text-center text-muted py-3">Tidak ada data</div>';
} else {
 mysqli_data_seek($q,0);
 while($r=mysqli_fetch_assoc($q)){
?>
<div class="card shadow-sm">
 <div class="card-body">
    <div class="d-flex justify-content-between">
        <div class="mobile-header"><?= $r['nama_siswa'] ?></div>
        <button class="btn btn-sm btn-outline-primary"
                data-bs-toggle="collapse"
                data-bs-target="#detail<?= $r['siswa_id'].$r['materi_id'] ?>">
            Detail
        </button>
    </div>

    <div id="detail<?= $r['siswa_id'].$r['materi_id'] ?>" class="collapse mt-2 mobile-details">
        Kelas: <?= $r['kelas_label'] ?><br>
        Mapel: <?= $r['nama_mapel'] ?><br>
        Materi: <?= $r['judul_materi'] ?><br>
        Soal: <?= $r['jumlah_soal'] ?><br>
        Waktu:
        <?= date('d-m-Y H:i', strtotime($r['mulai'])) ?> -
        <?= date('H:i', strtotime($r['selesai'])) ?>
        <hr class="my-2">
        <div class="d-flex gap-2">
            <a href="absen_dan_jawaban.php?s=<?= $r['siswa_id'] ?>&m=<?= $r['materi_id'] ?>" class="btn btn-info btn-sm w-50">Lihat</a>
            <a href="nilai_siswa.php?s=<?= $r['siswa_id'] ?>&m=<?= $r['materi_id'] ?>" class="btn btn-success btn-sm w-50">Nilai</a>
        </div>
    </div>

 </div>
</div>
<?php }} ?>
 </div>
</div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
