<?php
session_start();
require '../config/database.php';

/* ================= PROTEKSI ================= */
if (
    empty($_SESSION['login']) ||
    ($_SESSION['user']['role'] ?? '') !== 'tutor'
) {
    die('Akses ditolak');
}

/* ================= PARAMETER ================= */
$siswa_id  = (int)($_GET['s'] ?? 0);
$materi_id = (int)($_GET['m'] ?? 0);

if (!$siswa_id || !$materi_id) {
    die('Data tidak valid');
}

/* ================= DATA HEADER ================= */
$qHeader = mysqli_query($conn,"
 SELECT 
   s.nama AS nama_siswa,
   CONCAT(k.nama_kelas,'-',IFNULL(p.nama,'')) AS kelas,
   mp.nama_mapel,
   m.judul AS materi,
   COUNT(mjs.id) AS total_soal,
   SUM(mjs.benar) AS jumlah_benar,
   (COUNT(mjs.id) - SUM(mjs.benar)) AS jumlah_salah,
   ROUND((SUM(mjs.benar)/COUNT(mjs.id))*100,2) AS nilai,
   MIN(mjs.dijawab_pada) AS mulai,
   MAX(mjs.dijawab_pada) AS selesai
 FROM materi_jawaban_siswa mjs
 JOIN siswa s ON s.id = mjs.siswa_id
 JOIN kelas k ON k.id = s.kelas_id
 LEFT JOIN paket p ON p.id = k.paket_id
 JOIN materi m ON m.id = mjs.materi_id
 JOIN mapel mp ON mp.id = m.mapel_id
 WHERE mjs.siswa_id = '$siswa_id'
   AND mjs.materi_id = '$materi_id'
");

$data = mysqli_fetch_assoc($qHeader);
if(!$data){
    die('Data tidak ditemukan');
}

/* ================= DETAIL JAWABAN ================= */
$qDetail = mysqli_query($conn,"
 SELECT 
   so.pertanyaan,
   mjs.jawaban,
   mjs.benar
 FROM materi_jawaban_siswa mjs
 JOIN materi_soal so ON so.id = mjs.soal_id
 WHERE mjs.siswa_id = '$siswa_id'
   AND mjs.materi_id = '$materi_id'
 ORDER BY so.urutan ASC
");
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Cetak Nilai Siswa</title>
<style>
body{
    font-family:Arial, Helvetica, sans-serif;
    font-size:12px;
}
h3{
    text-align:center;
    margin-bottom:10px;
}
table{
    width:100%;
    border-collapse:collapse;
    margin-bottom:15px;
}
th,td{
    border:1px solid #000;
    padding:6px;
    vertical-align:top;
}
th{
    background:#eee;
}
.benar{
    color:green;
    font-weight:bold;
}
.salah{
    color:red;
    font-weight:bold;
}
@media print{
    .no-print{display:none}
}
</style>
</head>
<body onload="window.print()">

<h3>LAPORAN NILAI SISWA</h3>

<table>
<tr>
    <td width="25%">Nama Siswa</td>
    <td><?= htmlspecialchars($data['nama_siswa']) ?></td>
</tr>
<tr>
    <td>Kelas</td>
    <td><?= htmlspecialchars($data['kelas']) ?></td>
</tr>
<tr>
    <td>Mapel</td>
    <td><?= htmlspecialchars($data['nama_mapel']) ?></td>
</tr>
<tr>
    <td>Materi</td>
    <td><?= htmlspecialchars($data['materi']) ?></td>
</tr>
<tr>
    <td>Total Soal</td>
    <td><?= $data['total_soal'] ?></td>
</tr>
<tr>
    <td>Benar</td>
    <td><?= $data['jumlah_benar'] ?></td>
</tr>
<tr>
    <td>Salah</td>
    <td><?= $data['jumlah_salah'] ?></td>
</tr>
<tr>
    <td>Nilai</td>
    <td><strong><?= $data['nilai'] ?></strong></td>
</tr>
<tr>
    <td>Waktu</td>
    <td>
        <?= date('d-m-Y H:i',strtotime($data['mulai'])) ?>
        -
        <?= date('H:i',strtotime($data['selesai'])) ?>
    </td>
</tr>
</table>

<h4>Detail Jawaban</h4>

<table>
<tr>
    <th width="5%">No</th>
    <th>Pertanyaan</th>
    <th width="20%">Jawaban Siswa</th>
    <th width="10%">Status</th>
</tr>
<?php $no=1; while($d=mysqli_fetch_assoc($qDetail)){ ?>
<tr>
    <td align="center"><?= $no++ ?></td>
    <td><?= nl2br(htmlspecialchars($d['pertanyaan'])) ?></td>
    <td align="center"><?= htmlspecialchars($d['jawaban']) ?></td>
    <td align="center">
        <?= $d['benar']
            ? '<span class="benar">BENAR</span>'
            : '<span class="salah">SALAH</span>' ?>
    </td>
</tr>
<?php } ?>
</table>

</body>
</html>
