<?php
session_start();
require '../config/database.php';

if (
    empty($_SESSION['login']) ||
    ($_SESSION['user']['role'] ?? '') !== 'tutor'
) {
    header("Location: ../auth/login.php");
    exit;
}

$nama     = $_SESSION['user']['nama'] ?? '';
$email    = $_SESSION['user']['email'] ?? '';
$tutor_id = $_SESSION['user']['id'] ?? 0;

/* ================= FOTO ================= */
$foto = 'default.png';
$qFoto = mysqli_query($conn,"
    SELECT foto FROM tutor WHERE user_id='$tutor_id' LIMIT 1
");
if($d = mysqli_fetch_assoc($qFoto)){
    if(!empty($d['foto']) && file_exists("../uploads/tutor/".$d['foto'])){
        $foto = $d['foto'];
    }
}

/* ================= MENU ACTIVE ================= */
$halaman = basename($_SERVER['PHP_SELF']);
function aktif($file){
    global $halaman;
    return $halaman === $file ? 'active' : '';
}

/* ================= HITUNG ABSEN ================= */
$qAbsen = mysqli_query($conn,"
    SELECT COUNT(DISTINCT p.id) total
    FROM presensi p
    JOIN mapel mp ON mp.id = p.mapel_id
    JOIN kelas_mengajar km ON km.mapel_id = mp.id
    WHERE km.tutor_id = '$tutor_id'
");
$jml_absen = (int)(mysqli_fetch_assoc($qAbsen)['total'] ?? 0);

/* ================= HITUNG JAWABAN ================= */
$qJawaban = mysqli_query($conn,"
    SELECT COUNT(DISTINCT mjs.id) total
    FROM materi_jawaban_siswa mjs
    JOIN materi m ON m.id = mjs.materi_id
    JOIN kelas_mengajar km ON km.mapel_id = m.mapel_id
    WHERE km.tutor_id = '$tutor_id'
");
$jml_jawaban = (int)(mysqli_fetch_assoc($qJawaban)['total'] ?? 0);

/* ================= RESET PASSWORD ================= */
$success = $error = '';
if(isset($_POST['reset_password'])){
    $lama = $_POST['password_lama'];
    $baru = $_POST['password_baru'];
    $konf = $_POST['konfirmasi'];

    if(strlen($baru) < 6){
        $error = "Password minimal 6 karakter";
    }elseif($baru !== $konf){
        $error = "Konfirmasi password tidak cocok";
    }else{
        $q = mysqli_query($conn,"SELECT password FROM users WHERE id='$tutor_id'");
        $d = mysqli_fetch_assoc($q);

        if(!password_verify($lama,$d['password'])){
            $error = "Password lama salah";
        }else{
            $hash = password_hash($baru,PASSWORD_DEFAULT);
            mysqli_query($conn,"
                UPDATE users SET password='$hash'
                WHERE id='$tutor_id'
            ");
            $success = "Password berhasil diperbarui";
        }
    }
}
?>
<!doctype html>
<html lang="id">
<head>
<meta charset="utf-8">
<title>Profil Tutor</title>
<meta name="viewport" content="width=device-width, initial-scale=1">

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">

<style>
/* ===== STYLE ASLI SIDEBAR TUTOR (SAMA PERSIS) ===== */
.sidebar-tutor{
    width:260px;
    position:fixed;
    top:0; left:0;
    height:100vh;
    background:#0b1c2d;
    color:#fff;
    z-index:1030;
}
.sidebar-tutor a,
.sidebar-mobile a{
    display:flex;
    align-items:center;
    gap:14px;
    padding:12px 18px;
    margin:6px 12px;
    color:#fff;
    text-decoration:none;
    border-radius:14px;
}
.sidebar-tutor a:hover,
.sidebar-mobile a:hover,
.sidebar-tutor a.active,
.sidebar-mobile a.active{
    background:rgba(255,255,255,.18);
}
.sidebar-header{
    text-align:center;
    padding:20px 10px;
}
.sidebar-header img{
    width:70px;
    height:70px;
    border-radius:50%;
    object-fit:cover;
    border:3px solid rgba(255,255,255,.5);
}
.menu-flex{
    display:flex;
    justify-content:space-between;
    width:100%;
}
.topbar{
    position:fixed;
    top:0;
    left:260px;
    right:0;
    height:56px;
    background:#fff;
    border-bottom:1px solid #ddd;
    display:flex;
    align-items:center;
    padding:0 16px;
    z-index:1200;
}
.main-content{
    margin-left:260px;
    padding-top:72px;
}
/* ================= OFFCANVAS FIX ================= */
.offcanvas{
 z-index:1600;
}

@media(max-width:991px){
    .sidebar-tutor{display:none}
    .topbar{left:0}
    .main-content{margin-left:0}
}
/* ===== FOOTER MOBILE MENU ===== */
.footer-mobile{
 display:none;
}

@media(max-width:991px){
 .footer-mobile{
  display:flex;
  position:fixed;
  bottom:0;
  left:0;
  right:0;
  background:#fff;
  border-top:1px solid #ddd;
  z-index:999;
 }

 .footer-mobile a{
  flex:1;
  text-align:center;
  padding:8px 4px;
  font-size:11px;
  color:#666;
  text-decoration:none;
 }

 .footer-mobile a i{
  font-size:18px;
  display:block;
 }

 .footer-mobile a.active{
  color:#0d6efd;
  font-weight:600;
 }

 .footer-mobile a.active i{
  color:#0d6efd;
 }

 /* kasih ruang supaya konten ga ketutup footer */
 body{padding-bottom:65px}
}

</style>
</head>
<!-- FOOTER MOBILE -->
<div class="footer-mobile d-lg-none">

 <a href="profil.php" class="active">
  <i class="bi bi-person-circle"></i>
  Profil
 </a>

 <a href="absen_list_cetak.php">
  <i class="bi bi-clipboard-check"></i>
  Absen
 </a>

 <a href="materi.php">
  <i class="bi bi-journal-text"></i>
  Materi
 </a>

 <a href="elearning.php">
  <i class="bi bi-laptop"></i>
  E-Learning
 </a>

 <a href="absen_dan_jawaban.php">
  <i class="bi bi-ui-checks-grid"></i>
  Jawaban
 </a>

</div>

<body>
<!-- ================= SIDEBAR MOBILE ================= -->
<div class="offcanvas offcanvas-start sidebar-mobile text-white"
     tabindex="-1"
     id="sidebarTutor"
     style="background:#0b1c2d;width:260px">

    <div class="offcanvas-header">
        <div class="text-center w-100">
            <img src="../uploads/tutor/<?= htmlspecialchars($foto) ?>"
                 style="width:60px;height:60px;border-radius:50%;object-fit:cover"
                 onerror="this.src='../uploads/tutor/default.png'">
            <h6 class="mt-2 mb-0"><?= htmlspecialchars($nama) ?></h6>
            <small class="opacity-75">Tutor</small>
        </div>
        <button type="button"
                class="btn-close btn-close-white"
                data-bs-dismiss="offcanvas"></button>
    </div>

    <div class="offcanvas-body p-2">

        <a href="dashboard.php" class="<?= aktif('dashboard.php') ?>">
            <i class="bi bi-speedometer2"></i> Dashboard
        </a>

        <a href="profil.php" class="<?= aktif('profil.php') ?>">
            <i class="bi bi-person-circle"></i> Profil
        </a>

        <a href="absen_list_cetak.php" class="<?= aktif('absen_list_cetak.php') ?>">
            <div class="menu-flex">
                <span><i class="bi bi-clipboard-check"></i> Absen</span>
                <?php if($jml_absen){ ?>
                    <span class="badge bg-danger"><?= $jml_absen ?></span>
                <?php } ?>
            </div>
        </a>

        <a href="jawaban_siswa.php" class="<?= aktif('jawaban_siswa.php') ?>">
            <div class="menu-flex">
                <span><i class="bi bi-pencil-square"></i> Jawaban</span>
                <?php if($jml_jawaban){ ?>
                    <span class="badge bg-success"><?= $jml_jawaban ?></span>
                <?php } ?>
            </div>
        </a>

        <a href="materi.php" class="<?= aktif('materi.php') ?>">
            <i class="bi bi-journal-text"></i> Materi
        </a>

        <a href="elearning.php" class="<?= aktif('elearning.php') ?>">
            <i class="bi bi-laptop"></i> E-Learning
        </a>

        <a href="jadwal.php" class="<?= aktif('jadwal.php') ?>">
            <i class="bi bi-calendar-week"></i> Jadwal
        </a>

        <a href="kelas_mengajar.php" class="<?= aktif('kelas_mengajar.php') ?>">
            <i class="bi bi-diagram-3"></i> Kelas
        </a>

        <hr class="text-secondary">

        <a href="../auth/logout.php" class="text-warning">
            <i class="bi bi-box-arrow-right"></i> Logout
        </a>

    </div>
</div>

<!-- ================= SIDEBAR DESKTOP (ASLI) ================= -->
<div class="sidebar-tutor d-none d-lg-block">
    <div class="sidebar-header">
        <img src="../uploads/tutor/<?= htmlspecialchars($foto) ?>"
             onerror="this.src='../uploads/tutor/default.png'">
        <h6 class="mt-2"><?= htmlspecialchars($nama) ?></h6>
        <small class="opacity-75">Tutor</small>
    </div>

    <a href="dashboard.php" class="<?= aktif('dashboard.php') ?>">
        <i class="bi bi-speedometer2"></i> Dashboard
    </a>

    <a href="profil.php" class="<?= aktif('profil.php') ?>">
        <i class="bi bi-person-circle"></i> Profil
    </a>

    <a href="absen_list_cetak.php" class="<?= aktif('absen_list_cetak.php') ?>">
        <div class="menu-flex">
            <span><i class="bi bi-clipboard-check"></i> Absen</span>
            <?php if($jml_absen){ ?><span class="badge bg-danger"><?= $jml_absen ?></span><?php } ?>
        </div>
    </a>

    <a href="jawaban_siswa.php" class="<?= aktif('jawaban_siswa.php') ?>">
        <div class="menu-flex">
            <span><i class="bi bi-pencil-square"></i> Jawaban</span>
            <?php if($jml_jawaban){ ?><span class="badge bg-success"><?= $jml_jawaban ?></span><?php } ?>
        </div>
    </a>

    <a href="materi.php" class="<?= aktif('materi.php') ?>">
        <i class="bi bi-journal-text"></i> Materi
    </a>

    <a href="elearning.php" class="<?= aktif('elearning.php') ?>">
        <i class="bi bi-laptop"></i> E-Learning
    </a>

    <a href="jadwal.php" class="<?= aktif('jadwal.php') ?>">
        <i class="bi bi-calendar-week"></i> Jadwal
    </a>

    <a href="kelas_mengajar.php" class="<?= aktif('kelas_mengajar.php') ?>">
        <i class="bi bi-diagram-3"></i> Kelas
    </a>

    <hr class="text-secondary mx-3">

    <a href="../auth/logout.php" class="text-warning">
        <i class="bi bi-box-arrow-right"></i> Logout
    </a>
</div>

<!-- ================= TOPBAR ================= -->
<div class="topbar">
    <button class="btn btn-outline-primary d-lg-none"
            data-bs-toggle="offcanvas"
            data-bs-target="#sidebarTutor">
        <i class="bi bi-list"></i>
    </button>
    <span class="fw-semibold ms-2">Profil Tutor</span>
</div>

<!-- ================= MAIN CONTENT ================= -->
<div class="main-content">
<div class="container py-4">

<div class="card shadow-sm mx-auto" style="max-width:520px">
<div class="card-body text-center">

<img src="../uploads/tutor/<?= htmlspecialchars($foto) ?>"
     class="rounded-circle mb-3"
     style="width:120px;height:120px;object-fit:cover"
     onerror="this.src='../uploads/tutor/default.png'">

<h4 class="fw-bold"><?= htmlspecialchars($nama) ?></h4>
<p class="text-muted"><?= htmlspecialchars($email) ?></p>

<hr>

<h6 class="fw-bold text-start mb-3">
    <i class="bi bi-key"></i> Reset Password
</h6>

<?php if($error){ ?><div class="alert alert-danger"><?= $error ?></div><?php } ?>
<?php if($success){ ?><div class="alert alert-success"><?= $success ?></div><?php } ?>

<form method="post">
    <input type="password" name="password_lama" class="form-control mb-2" placeholder="Password Lama" required>
    <input type="password" name="password_baru" class="form-control mb-2" placeholder="Password Baru" required>
    <input type="password" name="konfirmasi" class="form-control mb-3" placeholder="Konfirmasi Password" required>
    <button class="btn btn-primary w-100" name="reset_password">
        <i class="bi bi-lock-fill"></i> Update Password
    </button>
</form>

</div>
</div>

</div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
