<?php
$nama     = $_SESSION['user']['nama'] ?? '';
$tutor_id = $_SESSION['user']['id'] ?? 0;

/* ===== AMBIL FOTO TUTOR DARI DATABASE ===== */
$foto = 'default.png';

if ($tutor_id) {
    $qFoto = mysqli_query($conn,"
        SELECT foto FROM tutor
        WHERE user_id = '$tutor_id'
        LIMIT 1
    ");
    if ($dFoto = mysqli_fetch_assoc($qFoto)) {
        if (!empty($dFoto['foto']) &&
            file_exists("../uploads/tutor/".$dFoto['foto'])) {
            $foto = $dFoto['foto'];
        }
    }
}


$halaman = basename($_SERVER['PHP_SELF']);
function aktif($file){
    global $halaman;
    return $halaman === $file ? 'active' : '';
}

/* ================= HITUNG ABSEN ================= */
$qAbsen = mysqli_query($conn,"
    SELECT COUNT(DISTINCT p.id) total
    FROM presensi p
    JOIN mapel mp ON mp.id = p.mapel_id
    JOIN kelas_mengajar km ON km.mapel_id = mp.id
    WHERE km.tutor_id = '$tutor_id'
");
$jml_absen = (int)(mysqli_fetch_assoc($qAbsen)['total'] ?? 0);

/* ================= HITUNG JAWABAN ================= */
$qJawaban = mysqli_query($conn,"
    SELECT COUNT(DISTINCT mjs.id) total
    FROM materi_jawaban_siswa mjs
    JOIN materi m ON m.id = mjs.materi_id
    JOIN kelas_mengajar km ON km.mapel_id = m.mapel_id
    WHERE km.tutor_id = '$tutor_id'
");
$jml_jawaban = (int)(mysqli_fetch_assoc($qJawaban)['total'] ?? 0);
?>

<style>
/* ================= SIDEBAR DESKTOP ================= */
.sidebar-tutor{
    width:260px;
    position:fixed;
    top:0; left:0;
    height:100vh;
    background:#0b1c2d;
    color:#fff;
    z-index:1030;
}

/* LINK */
.sidebar-tutor a,
.sidebar-mobile a{
    display:flex;
    align-items:center;
    gap:12px;
    padding:12px 18px;
    margin:6px 12px;
    color:#fff;
    text-decoration:none;
    border-radius:14px;
    transition:.2s;
}

/* ACTIVE & HOVER */
.sidebar-tutor a:hover,
.sidebar-mobile a:hover,
.sidebar-tutor a.active,
.sidebar-mobile a.active{
    background:rgba(255,255,255,.18);
}

/* HEADER */
.sidebar-header{
    text-align:center;
    padding:20px 10px;
}
.sidebar-header img{
    width:70px;
    height:70px;
    border-radius:50%;
    object-fit:cover;
    border:3px solid rgba(255,255,255,.5);
}
.sidebar-header h6{
    margin:10px 0 0;
    font-weight:700;
}

/* MENU FLEX + BADGE */
.menu-flex{
    display:flex;
    justify-content:space-between;
    align-items:center;
    width:100%;
}

.sidebar-tutor .badge,
.sidebar-mobile .badge{
    font-size:11px;
    padding:4px 7px;
    border-radius:12px;
}

/* MOBILE */
@media(max-width:991px){
    .sidebar-tutor{display:none}
}
</style>

<!-- ================= SIDEBAR DESKTOP ================= -->
<div class="sidebar-tutor d-none d-lg-block">
    <div class="sidebar-header">
        <img src="../uploads/tutor/<?= htmlspecialchars($foto) ?>">
        <h6><?= htmlspecialchars($nama) ?></h6>
        <small class="opacity-75">Tutor</small>
    </div>

    <a href="dashboard.php" class="<?= aktif('dashboard.php') ?>">
        <i class="bi bi-speedometer2"></i> Dashboard
    </a>

    <a href="profil.php" class="<?= aktif('profil.php') ?>">
        <i class="bi bi-person-circle"></i> Profil
    </a>

    <!-- ABSEN -->
    <a href="absen_list_cetak.php" class="<?= aktif('absen_list_cetak.php') ?>">
    <div class="menu-flex">
        <span><i class="bi bi-clipboard-check"></i> Absen</span>
        <?php if($jml_absen > 0){ ?>
            <span class="badge bg-danger"><?= $jml_absen ?></span>
        <?php } ?>
    </div>
</a>


    <!-- JAWABAN -->
    <a href="jawaban_siswa.php#jawaban" class="<?= aktif('jawaban_siswa.php') ?>">
        <div class="menu-flex">
            <span><i class="bi bi-pencil-square"></i> Jawaban</span>
            <?php if($jml_jawaban > 0){ ?>
                <span class="badge bg-success"><?= $jml_jawaban ?></span>
            <?php } ?>
        </div>
    </a>

    <a href="materi.php" class="<?= aktif('materi.php') ?>">
        <i class="bi bi-journal-text"></i> Materi
    </a>

    <a href="ebook_tutor.php" class="<?= aktif('ebook_tutor.php') ?>">
        <i class="bi bi-journal-text"></i> E-Book
    </a>

    <a href="elearning.php" class="<?= aktif('elearning.php') ?>">
        <i class="bi bi-laptop"></i> E-Learning
    </a>

    <a href="jadwal.php" class="<?= aktif('jadwal.php') ?>">
        <i class="bi bi-calendar-week"></i> Jadwal
    </a>

    <?php $active = basename($_SERVER['PHP_SELF']); ?>

<li class="nav-item">
    <a href="#" 
       class="nav-link <?= ($active=='index.php' && strpos($_SERVER['REQUEST_URI'],'zoom'))?'active':'' ?>">
        <i class="bi bi-camera-video"></i>
        <span>Kelas Online</span>
    </a>
</li>


    <hr class="text-secondary mx-3">

    <a href="../auth/logout.php" class="text-warning">
        <i class="bi bi-box-arrow-right"></i> Logout
    </a>
</div>

<!-- ================= SIDEBAR MOBILE ================= -->
<div class="offcanvas offcanvas-start sidebar-mobile text-white"
     tabindex="-1" id="sidebarTutor"
     style="background:#0b1c2d;width:260px">

    <div class="offcanvas-header">
        <div class="text-center w-100">
            <img src="../uploads/tutor/<?= htmlspecialchars($foto) ?>"
                 style="width:60px;height:60px;border-radius:50%">
            <h6 class="mt-2 mb-0"><?= htmlspecialchars($nama) ?></h6>
            <small class="opacity-75">Tutor</small>
        </div>
        <button class="btn-close btn-close-white"
                data-bs-dismiss="offcanvas"></button>
    </div>

    <div class="offcanvas-body p-2">

        <a href="dashboard.php" class="<?= aktif('dashboard.php') ?>">
            <i class="bi bi-speedometer2"></i> Dashboard
        </a>

        <a href="profil.php" class="<?= aktif('profil.php') ?>">
            <i class="bi bi-person-circle"></i> Profil
        </a>

        <a href="absen_list_cetak.php" class="<?= aktif('absen_list_cetak.php') ?>">
    <div class="menu-flex">
        <span><i class="bi bi-clipboard-check"></i> Absen</span>
        <?php if($jml_absen > 0){ ?>
            <span class="badge bg-danger"><?= $jml_absen ?></span>
        <?php } ?>
    </div>
</a>

        <a href="jawaban_siswa.php#jawaban" class="<?= aktif('jawaban_siswa.php') ?>">
            <div class="menu-flex">
                <span><i class="bi bi-pencil-square"></i> Jawaban</span>
                <?php if($jml_jawaban > 0){ ?>
                    <span class="badge bg-success"><?= $jml_jawaban ?></span>
                <?php } ?>
            </div>
        </a>

        <a href="materi.php" class="<?= aktif('materi.php') ?>">
            <i class="bi bi-journal-text"></i> Materi
        </a>

        <a href="elearning.php" class="<?= aktif('elearning.php') ?>">
            <i class="bi bi-laptop"></i> E-Learning
        </a>

        <a href="jadwal.php" class="<?= aktif('jadwal.php') ?>">
            <i class="bi bi-calendar-week"></i> Jadwal
        </a>
        <?php $active = basename($_SERVER['PHP_SELF']); ?>

<li class="nav-item">
    <a href="zoom/index.php" 
       class="nav-link <?= ($active=='index.php' && strpos($_SERVER['REQUEST_URI'],'zoom'))?'active':'' ?>">
        <i class="bi bi-camera-video"></i>
        <span>Zoom Meeting</span>
    </a>
</li>


        <hr class="text-secondary">

        <a href="../auth/logout.php" class="text-warning">
            <i class="bi bi-box-arrow-right"></i> Logout
        </a>
    </div>
</div>
