<?php
session_start();
require "../../config/database.php";

if(empty($_SESSION['login_tutor'])){
    header("Location: ../../auth/login_tutor.php");
    exit;
}

$id = intval($_GET['id'] ?? 0);

$q = mysqli_query($conn,"
SELECT pz.*, s.nama, k.nama_kelas, m.nama_mapel
FROM presensi_zoom pz
JOIN siswa s ON pz.siswa_id = s.id
JOIN zoom_meeting z ON pz.zoom_id = z.id
JOIN kelas k ON z.kelas_id = k.id
LEFT JOIN mapel m ON z.mapel_id = m.id
WHERE z.id='$id'
ORDER BY pz.created_at DESC
");
?>
<!DOCTYPE html>
<html>
<head>
<title>Laporan Presensi Zoom</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">

<div class="container py-4">
<h4>Laporan Presensi Zoom</h4>

<table class="table table-bordered table-striped">
<thead>
<tr>
<th>No</th>
<th>Nama</th>
<th>Kelas</th>
<th>Mapel</th>
<th>Tanggal</th>
<th>Jam</th>
<th>Foto</th>
</tr>
</thead>
<tbody>
<?php $no=1; while($r=mysqli_fetch_assoc($q)): ?>
<tr>
<td><?= $no++ ?></td>
<td><?= htmlspecialchars($r['nama']) ?></td>
<td><?= htmlspecialchars($r['nama_kelas']) ?></td>
<td><?= htmlspecialchars($r['nama_mapel']) ?></td>
<td><?= $r['tanggal'] ?></td>
<td><?= $r['jam'] ?></td>
<td>
<?php if($r['foto']): ?>
<img src="<?= $r['foto'] ?>" width="60">
<?php endif; ?>
</td>
</tr>
<?php endwhile; ?>
</tbody>
</table>

<a href="index.php" class="btn btn-secondary">Kembali</a>

</div>
</body>
</html>
