<?php
session_start();
require __DIR__ . '/../../config/database.php';


/* ================= CEK LOGIN SISWA ================= */
if (empty($_SESSION['login_siswa'])) {
    header("Location: ../auth/login_siswa.php");
    exit;
}

$siswa_id   = $_SESSION['siswa']['id'];
$nama_siswa = $_SESSION['siswa']['nama'];
$kelas      = $_SESSION['siswa']['kelas'];

/* ================= AMBIL MAPEL AKTIF ================= */
$mapel = mysqli_fetch_assoc(mysqli_query($conn,"
    SELECT * FROM jadwal_live 
    WHERE kelas='$kelas' AND status='aktif'
    ORDER BY tanggal DESC LIMIT 1
"));

if(!$mapel){
    die("<center style='margin-top:100px;font-family:sans-serif'>
    <h2>Belum ada kelas LIVE untuk kelas $kelas</h2></center>");
}

/* ================= DATA ROOM ================= */
$roomName = "PKBM_".str_replace(" ","_",$kelas)."_".$mapel['mapel'];
$password = $mapel['password'];
$jam_mulai = strtotime($mapel['tanggal']." ".$mapel['jam_mulai']);
$now = time();
$selisih = $jam_mulai - $now;
?>
<!DOCTYPE html>
<html>
<head>
<meta charset="utf-8">
<title>Live Class</title>
<script src='https://meet.jit.si/external_api.js'></script>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<style>
body{
    margin:0;
    background:#0f172a;
    color:white;
    font-family:Arial;
}
.header{
    padding:15px;
    background:#111827;
    display:flex;
    justify-content:space-between;
    align-items:center;
}
.badge{
    background:limegreen;
    padding:5px 10px;
    border-radius:20px;
    font-size:12px;
}
#countdown{
    font-size:18px;
    color:orange;
}
#jitsi-container{
    width:100%;
    height:90vh;
}
.popup{
    position:fixed;
    top:0;left:0;
    width:100%;
    height:100%;
    background:rgba(0,0,0,0.8);
    display:flex;
    justify-content:center;
    align-items:center;
    flex-direction:column;
}
.popup input{
    padding:10px;
    margin:10px;
    width:200px;
}
.popup button{
    padding:10px 20px;
    background:orange;
    border:none;
    cursor:pointer;
}
@media(max-width:768px){
    #jitsi-container{ height:85vh; }
}
</style>
</head>
<body>

<div class="header">
    <div>
        <strong><?= $mapel['mapel'] ?></strong> | 
        Kelas <?= $kelas ?> | 
        Guru: <?= $mapel['nama_guru'] ?>
    </div>
    <div id="countdown"></div>
</div>

<!-- POPUP PASSWORD -->
<div class="popup" id="passwordPopup">
    <h2>Masukkan Password Kelas</h2>
    <input type="password" id="roomPassword">
    <button onclick="checkPassword()">Masuk</button>
</div>

<div id="jitsi-container"></div>

<script>
var selisih = <?= $selisih ?>;
var countdownEl = document.getElementById("countdown");

if(selisih > 0){
    var interval = setInterval(function(){
        selisih--;
        var menit = Math.floor(selisih/60);
        var detik = selisih%60;
        countdownEl.innerHTML = "Mulai dalam "+menit+"m "+detik+"s";
        if(selisih<=0){
            clearInterval(interval);
            countdownEl.innerHTML = "<span class='badge'>LIVE</span>";
        }
    },1000);
}else{
    countdownEl.innerHTML = "<span class='badge'>LIVE</span>";
}

/* ================= CEK PASSWORD ================= */
function checkPassword(){
    var input = document.getElementById("roomPassword").value;
    if(input === "<?= $password ?>"){
        document.getElementById("passwordPopup").style.display="none";
        startJitsi();
        absensi();
    }else{
        alert("Password salah!");
    }
}

/* ================= START JITSI ================= */
function startJitsi(){
    const domain = "meet.jit.si";
    const options = {
        roomName: "<?= $roomName ?>",
        width: "100%",
        height: "100%",
        parentNode: document.querySelector('#jitsi-container'),
        userInfo: {
            displayName: "<?= $nama_siswa ?>"
        },
        configOverwrite: {
            startWithAudioMuted: false,
            startWithVideoMuted: false
        }
    };
    const api = new JitsiMeetExternalAPI(domain, options);
}

/* ================= ABSENSI ================= */
function absensi(){
    fetch("absensi.php",{
        method:"POST",
        headers:{'Content-Type':'application/x-www-form-urlencoded'},
        body:"siswa_id=<?= $siswa_id ?>&mapel=<?= $mapel['mapel'] ?>"
    });
}
</script>

</body>
</html>
