<?php
session_start();
require "koneksi.php";

/* ================= AUTH ================= */
if (empty($_SESSION['login_tutor'])) {
  header("Location: login.php");
  exit;
}

/* ================= SESSION ID ================= */
$tutor_id = (int)($_SESSION['tutor_id'] ?? 0);

/* ================= DEFAULT ================= */
$nama  = '-';
$email = '-';
$pendidikan = '-';
$foto  = 'default.png';

/* ================= JOIN USERS + TUTOR ================= */
$q = mysqli_query($conn, "
  SELECT 
    u.nama AS nama_user,
    t.email AS email_tutor,
    t.foto AS foto_tutor,
    t.pendidikan
  FROM tutor t
  LEFT JOIN users u ON u.id = t.user_id
  WHERE t.id = '$tutor_id'
  LIMIT 1
");

if ($q && mysqli_num_rows($q) === 1) {
  $d = mysqli_fetch_assoc($q);

  $nama       = !empty($d['nama_user']) ? $d['nama_user'] : '-';
  $email      = !empty($d['email_tutor']) ? $d['email_tutor'] : '-';
  $pendidikan = !empty($d['pendidikan']) ? $d['pendidikan'] : '-';
  $foto       = !empty($d['foto_tutor']) ? $d['foto_tutor'] : 'default.png';
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Profil Tutor</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<style>
*{box-sizing:border-box}
html,body{height:100%;margin:0}

body{
  font-family:'Segoe UI',sans-serif;
  background:linear-gradient(135deg,#f7e38c,#b9e4a6,#a3d9f5);
  display:flex;
  justify-content:center;
  align-items:flex-start;
  padding:16px 0 80px;
}

/* PHONE */
.phone{
  width:360px;
  max-width:95vw;
  background:#fff;
  border-radius:26px;
  box-shadow:0 8px 20px rgba(0,0,0,.18);
  padding:18px;
  text-align:center;
  margin-top:10px;
}

/* FOTO */
.avatar{
  width:120px;
  height:120px;
  border-radius:50%;
  object-fit:cover;
  border:4px solid #f57c00;
  margin:10px auto 6px;
  box-shadow:0 6px 14px rgba(0,0,0,.25);
  display:block;
  background:#eee;
}

/* INFO */
.info{
  background:#f9f9f9;
  border-radius:16px;
  padding:14px;
  margin-top:14px;
  text-align:left;
}
.info div{
  margin-bottom:10px;
  font-size:14px;
}
.info b{
  display:inline-block;
  width:95px;
}

/* BUTTON */
button{
  width:100%;
  padding:14px;
  border:none;
  border-radius:14px;
  background:#eee;
  color:#333;
  font-size:15px;
  font-weight:700;
  margin-top:16px;
  cursor:pointer;
}
button:active{transform:scale(.97)}

/* FOOTER */
.footer{
  position:fixed;
  bottom:0;left:0;right:0;
  background:#fff;
  border-top:1px solid #ddd;
  display:flex;
  justify-content:space-around;
  padding:6px 0;
}
.footer a{
  font-size:11px;
  color:#777;
  text-decoration:none;
  text-align:center
}
.footer span{
  display:block;
  font-size:18px
}
.footer a.active{
  color:#f57c00;
  font-weight:600
}
</style>
</head>

<body>

<div class="phone">

  <!-- FOTO -->
  <img 
    src="../edu_digital/uploads/tutor/<?= htmlspecialchars($foto) ?>" 
    class="avatar"
    loading="eager"
    onerror="this.src='../edu_digital/uploads/tutor/default.png'">

  <h3><?= htmlspecialchars($nama) ?></h3>


  <div class="info">
    <div><b>Nama</b>: <?= htmlspecialchars($nama) ?></div>
    <div><b>Email</b>: <?= htmlspecialchars($email) ?></div>
    <div><b>Pendidikan</b>: <?= htmlspecialchars($pendidikan) ?></div>
  </div>

  <button onclick="logout()">🚪 Logout</button>

</div>

<!-- FOOTER -->
<div class="footer">
  <a href="dashboard.php"><span>🏠</span>Home</a>
  <a href="presensi.php"><span>📸</span>Presensi</a>
  <a href="izin.php"><span>📝</span>Izin</a>
  <a href="history.php"><span>📜</span>History</a>
  <a class="active"><span>👤</span>Profil</a>
</div>

<script>
function logout(){
  if(confirm("Yakin ingin logout?")){
    fetch("logout.php")
      .catch(()=>{})
      .finally(()=>{
        window.location.href = "../index.html";
      });
  }
}
</script>


</body>
</html>
