<?php
session_start();

/* ================= DATABASE ================= */
$conn = null;
$dbPath = __DIR__ . '/edu_digital/config/database.php';

if (file_exists($dbPath)) {
    require_once $dbPath;
}

if (!isset($conn)) {
    $conn = null; // cegah error jika database tidak ada
}

/* ================= DATA ================= */

// ================= KEPALA SEKOLAH =================
$kepsek = null;

if ($conn) {
    $qKepsek = mysqli_query($conn,"
        SELECT * FROM guru_manajemen
        WHERE status = 'Kepala Sekolah'
        ORDER BY id DESC
        LIMIT 1
    ");

    if($qKepsek && mysqli_num_rows($qKepsek) > 0){
        $kepsek = mysqli_fetch_assoc($qKepsek);
    }
}

/* ================= PENDIRI ================= */
$pendiri = null;

if ($conn) {
    $qPendiri = mysqli_query($conn,"
        SELECT * FROM guru_manajemen
        WHERE jabatan LIKE '%pendiri%'
        ORDER BY id ASC
        LIMIT 1
    ");

    if($qPendiri && mysqli_num_rows($qPendiri) > 0){
        $pendiri = mysqli_fetch_assoc($qPendiri);
    }
}
// ================= FOUNDER / MANAJEMEN =================
$manajemen = null;

if ($conn) {
    $manajemen = mysqli_query($conn,"
        SELECT * FROM guru_manajemen
        WHERE jabatan NOT LIKE '%guru%'
        AND jabatan NOT LIKE '%kepala%'
        AND jabatan NOT LIKE '%ahli%'
        ORDER BY nama
    ");
}

$fotoFolder  = '/pkbm-test/edu_digital/uploads/guru-manajemen/';
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Profil Tutor & Manajemen</title>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
<style>
body{
  min-height:100vh;
  font-family:'Segoe UI',sans-serif;
  background:#f1f5f9;
}

.phone{
  max-width:430px;
  margin:auto;
  min-height:100vh;
  background:linear-gradient(180deg,#5f8fb8,#87a8c6);
  padding-bottom:70px;
}

/* HEADER */
.header{
  display:flex;
  align-items:center;
  justify-content:space-between;
  padding:12px 10px;
  background:linear-gradient(120deg,#020617,#0d6efd);
  color:#fff;
  font-weight:600;
  font-size:15px;
}

.logo{
  width:40px;
  height:40px;
  border-radius:50%;
  object-fit:cover;
  background:#fff;
}

.header span{
  flex:1;
  text-align:center;
}

/* SLIDER */
.slider-app img{
  width:100%;
  height:200px;
  object-fit:cover;
}

/* ===== SAMBUTAN MODERN COMPACT ===== */
.sambutan-flex{
  background:linear-gradient(135deg,#ffffff,#f8fafc);
  margin:10px 12px 20px;
  border-radius:14px;
  padding:12px;
  display:flex;
  gap:10px;
  align-items:flex-start;
  box-shadow:0 5px 18px rgba(0,0,0,.08);
  position:relative;
}

/* ===== FOTO SAMBUTAN PREMIUM (FIX PROPORSI) ===== */
.sambutan-foto{
  width:95px;
  height:135px;              /* lebih proporsional */
  border-radius:10px;        /* kotak soft */
  object-fit:cover;
  object-position:top;       /* fokus wajah */
  flex-shrink:0;
  padding:3px;
  background:linear-gradient(135deg,#2563eb,#3b82f6,#60a5fa);
  box-shadow:0 6px 16px rgba(37,99,235,.35);
  transition:transform .3s ease;
}

.sambutan-foto:hover{
  transform:scale(1.04);     /* jangan terlalu besar */
}
/* MOBILE kecil */
@media(max-width:380px){
  .sambutan-foto{
    width:58px;
    height:78px;
  }
}


/* ===== TEXT SAMBUTAN LEBIH RAPI & FORMAL ===== */
.sambutan-text{
  flex:1;
}

/* Nama */
.sambutan-text h6{
  font-size:14px;
  font-weight:700;
  margin-bottom:3px;
  color:#0f172a;
  letter-spacing:.3px;
}

/* Jabatan */
.sambutan-text small{
  font-size:12px;
  color:#64748b;
  display:block;
  margin-bottom:8px;
  font-weight:500;
}

/* Isi Sambutan */
.sambutan-isi{
  margin-top:6px;
}

.sambutan-isi p{
  font-size:13.5px;
  line-height:1.75;      /* lebih lega */
  margin-bottom:10px;    /* jarak antar paragraf */
  text-align:justify;
  color:#334155;
}

/* Paragraf pertama dan terakhir lebih tegas */
.sambutan-isi p strong{
  color:#0d6efd;
  font-weight:600;
}
.sambutan-isi p{
  text-indent:20px;
}
/* ===== FOUNDER PREMIUM CARD ===== */
.founder-modern{
  display:flex;
  justify-content:space-between;
  margin:0 12px 16px;
  gap:14px;
}

.founder-card{
  width:50%;
  background:#334155;
  border-radius:16px;
  overflow:hidden;
  box-shadow:0 8px 22px rgba(0,0,0,.08);
  transition:all .3s ease;
}

.founder-card:hover{
  transform:translateY(-6px);
  box-shadow:0 14px 28px rgba(0,0,0,.15);
}

.founder-img-wrap{
  width:100%;
  height:160px;
  overflow:hidden;
}

.founder-img-wrap img{
  width:100%;
  height:100%;
  object-fit:cover;
  object-position:top;
}

.founder-info{
  padding:10px 8px 12px;
  text-align:center;
}

.founder-name{
  font-size:13px;
  font-weight:700;
  color:#ffffff;
  margin-bottom:3px;
}

.founder-jabatan{
  font-size:11px;
  color:#0d6efd;
  font-weight:600;
}
/* ===== MENU BUTTON MODERN CLEAN ===== */
.menu-btn{
  margin:14px 15px;
}

.menu-btn a{
  display:block;
  text-align:center;
  padding:14px 12px;
  background:#ffffff;
  border-radius:14px;
  text-decoration:none;
  color:#0f172a;
  font-weight:600;
  font-size:14px;
  letter-spacing:.3px;
  box-shadow:0 6px 18px rgba(0,0,0,.08);
  transition:all .25s ease;
}

/* hover effect lebih menarik */
.menu-btn a:hover{
  transform:translateY(-5px) scale(1.03);
  box-shadow:0 14px 30px rgba(13,110,253,.25);
  background:linear-gradient(135deg,#0d6efd,#2563eb,#60a5fa);
  color:#ffffff;
  letter-spacing:.5px;
  transition:all .35s ease;
}
.menu-btn a:hover{
  text-shadow:0 0 6px rgba(255,255,255,.6);
}

/* ===== BOTTOM NAV MODERN ===== */
.bottom{
  position:fixed;
  bottom:0;
  width:100%;
  max-width:430px;
  height:65px;
  background:linear-gradient(120deg,#0d6efd,#1d4ed8);
  display:flex;
  justify-content:space-around;
  align-items:center;
  box-shadow:0 -6px 20px rgba(0,0,0,.18);
  border-top-left-radius:18px;
  border-top-right-radius:18px;
}

/* link style */
.bottom a{
  flex:1;
  text-align:center;
  color:#e2e8f0;
  text-decoration:none;
  font-size:12px;
  font-weight:500;
  padding:6px 0;
  transition:all .3s ease;
  position:relative;
}

/* hover */
.bottom a:hover{
  color:#ffffff;
  transform:translateY(-3px);
}

/* active */
.bottom a.active{
  color:#ffffff;
  font-weight:700;
}

.bottom a.active::after{
  content:'';
  position:absolute;
  bottom:0;
  left:25%;
  width:50%;
  height:3px;
  background:#ffffff;
  border-radius:3px;
}
/* ===== FOOTER ICON WARNA ===== */
.bottom a i{
  font-size:18px;
  transition:.3s;
}

/* HOME */
.bottom a:nth-child(1) i{
  color:#facc15;
}

/* JADWAL */
.bottom a:nth-child(2) i{
  color:#22c55e;
}

/* CHAT */
.bottom a:nth-child(3) i{
  color:#0ea5e9;
}

/* PROFIL */
.bottom a:nth-child(4) i{
  color:#f472b6;
}

/* ACTIVE lebih terang */
.bottom a.active i{
  filter:brightness(1.4);
  transform:scale(1.15);
}

/* HOVER animasi */
.bottom a:hover i{
  transform:translateY(-4px) scale(1.1);
}
</style>
</head>

<body>

<div class="phone">

<!-- HEADER -->
<div class="header">
  <img src="assets/img/logo_kiri.PNG" class="logo">
  <span>DHARMANANDA AGUNG ACADEMY</span>
  <img src="assets/img/logo_kanan.PNG" class="logo">
</div>

<!-- SLIDER -->
<div id="sliderSekolah" class="carousel slide slider-app" data-bs-ride="carousel">
<div class="carousel-inner">
<?php
$folderSlide = $_SERVER['DOCUMENT_ROOT']."/pkbm-test/assets/slide/";
$urlSlide    = "/pkbm-test/assets/slide/";

if (is_dir($folderSlide)) {
    $files = glob($folderSlide."*.{jpg,jpeg,png,webp}", GLOB_BRACE);
} else {
    $files = [];
}

$no=0;

if(!empty($files)):
foreach($files as $f):
$img = basename($f);
?>
<div class="carousel-item <?= $no==0?'active':'' ?>">
<img src="<?= $urlSlide . htmlspecialchars($img) ?>" alt="Slide Sekolah">
</div>
<?php $no++; endforeach; endif; ?>
</div>
</div>

<!-- SAMBUTAN -->
<?php if($kepsek): ?>
<div class="sambutan-flex">

<img class="sambutan-foto"
src="<?= $fotoFolder . (!empty($kepsek['foto']) ? htmlspecialchars($kepsek['foto']) : 'default.png') ?>"
alt="Foto Kepala Sekolah">

<div class="sambutan-text">

  <h6><?= htmlspecialchars($kepsek['nama']) ?></h6>
  <small><?= htmlspecialchars($kepsek['jabatan']) ?></small>

  <div class="sambutan-isi">
    <p style="direction: rtl; unicode-bidi: embed; font-size: 20px; font-family: 'Scheherazade New', serif;">
    السَّلاَمُ عَلَيْكُمْ وَرَحْمَةُ اللهِ وَبَرَكَاتُهُ
</p>
    <p>
      Selamat datang di Aplikasi resmi <b>DHARMANANDA AGUNG ACADEMY</b>.
      Kami berkomitmen memberikan pendidikan terbaik dalam membentuk
      generasi unggul, berakhlak mulia, serta siap menghadapi tantangan masa depan.
    </p>
    <p>
      Semoga Aplikasi ini menjadi sarana informasi yang bermanfaat bagi siswa,
      orang tua, dan masyarakat.
    </p>
    <p style="font-size: 20px; font-family: 'Times New Roman', serif;">
  <span lang="ar" dir="rtl">وَعَلَيْكُمُ السَّلاَمُ وَرَحْمَةُ اللهِ وَبَرَكَاتُهُ</span>
</p>

  </div>

</div>
</div>
<?php endif; ?>


<!-- FOTO PENDIRI & KEPSEK -->
<?php if($pendiri || $kepsek): ?>
<div class="founder-modern">

<?php if($pendiri): ?>
<div class="founder-card">
    <div class="founder-img-wrap">
        <img src="<?= $fotoFolder . (!empty($pendiri['foto']) ? htmlspecialchars($pendiri['foto']) : 'default.png') ?>"
        alt="Foto Pendiri">
    </div>
    <div class="founder-info">
        <div class="founder-name">
            <?= htmlspecialchars($pendiri['nama']) ?>
        </div>
        <div class="founder-jabatan">
            <?= htmlspecialchars($pendiri['jabatan']) ?>
        </div>
    </div>
</div>
<?php endif; ?>

<?php if($kepsek): ?>
<div class="founder-card">
    <div class="founder-img-wrap">
        <img src="<?= $fotoFolder . (!empty($kepsek['foto']) ? htmlspecialchars($kepsek['foto']) : 'default.png') ?>"
        alt="Foto Kepala Sekolah">
    </div>
    <div class="founder-info">
        <div class="founder-name">
            <?= htmlspecialchars($kepsek['nama']) ?>
        </div>
        <div class="founder-jabatan">
            <?= htmlspecialchars($kepsek['jabatan']) ?>
        </div>
    </div>
</div>
<?php endif; ?>

</div>
<?php endif; ?>
<!-- MENU -->
<div class="menu-btn">
  <a href="/pkbm-test/pendiri.php"><span>Lihat Founder</span></a>
</div>

<div class="menu-btn">
  <a href="/pkbm-test/manajemen_staf.php"><span>Lihat Tutor & Management</span></a>
</div>

<!-- NAV -->
<div class="bottom">
  <a href="index.html" class="active">
    <i class="bi bi-house"></i><br>Home
  </a>
  <a href="#">
    <i class="bi bi-calendar"></i><br>Jadwal
  </a>
  <a href="#">
    <i class="bi bi-chat-dots"></i><br>Chat
  </a>
  <a href="#">
    <i class="bi bi-person"></i><br>Profil
  </a>
</div>

</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>