<?php
require __DIR__ . '/../config/database.php';
if (session_status() === PHP_SESSION_NONE) session_start();

/* ================= PROFIL SEKOLAH ================= */
$nama_aplikasi = 'SMART CBT';
$nama_sekolah  = 'SEKOLAH';
$alamat        = 'Alamat Sekolah';
$logo          = 'default.png';

$q = mysqli_query($conn,"SELECT * FROM sekolah LIMIT 1");
if ($q && mysqli_num_rows($q)) {
    $s = mysqli_fetch_assoc($q);
    $nama_sekolah = $s['nama_sekolah'] ?? $nama_sekolah;
    $alamat = $s['alamat'] ?? $alamat;
    $logo = $s['logo'] ?? $logo;
}
if (!file_exists(__DIR__."/../assets/logo/$logo")) $logo='default.png';

/* ================= FILTER ================= */
$filter_kelas = trim($_GET['kelas'] ?? '');
$filter_siswa = trim($_GET['siswa'] ?? '');

if($filter_kelas==='') {
    die("Pilih kelas dulu");
}

/* ================= AMBIL SISWA ================= */
$siswa_list = [];

if($filter_siswa!=='') {
    // Ambil 1 siswa
    $qs = mysqli_query($conn2,"SELECT id, nisn, nama FROM siswa WHERE id='$filter_siswa' LIMIT 1");
    if($r = mysqli_fetch_assoc($qs)){
        $siswa_list[] = $r;
    } else {
        die("Data siswa tidak ditemukan");
    }
} else {
    // Ambil semua siswa di kelas
    $qs = mysqli_query($conn2,"
    SELECT s.id, s.nisn, s.nama
    FROM siswa s
    JOIN smart_cbt.hasil h ON h.id_siswa = s.id
    JOIN smart_cbt.ujian u ON u.id = h.id_ujian
    WHERE u.id_kelas='$filter_kelas'
    GROUP BY s.id
    ORDER BY s.nama
    ");
    while($r = mysqli_fetch_assoc($qs)){
        $siswa_list[] = $r;
    }
}

if(count($siswa_list)==0) die("Belum ada siswa untuk kelas ini");

/* ================= AMBIL NAMA KELAS ================= */
$qk = mysqli_query($conn2,"SELECT nama_kelas, paket_id FROM kelas WHERE id='$filter_kelas' LIMIT 1");
$kelas_info = mysqli_fetch_assoc($qk);
$kelas_nama = $kelas_info ? $kelas_info['nama_kelas'].'-'.chr(64+$kelas_info['paket_id']) : '';
?>

<!doctype html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Raport Full - <?= $kelas_nama ?></title>
<style>
body{font-family:Times New Roman;font-size:13px;color:#000}
.kop{text-align:center;border-bottom:3px double #000;padding-bottom:10px;margin-bottom:15px}
.kop img{width:80px;float:left}
.kop h3{margin:0;font-size:18px}
.kop p{margin:2px 0}
.clear{clear:both}

table{width:100%;border-collapse:collapse;margin-bottom:10px;}
th,td{border:1px solid #000;padding:6px;text-align:center;}
th{background:#eee;}

.identitas td{border:none;padding:3px;text-align:left;}
.ttd{margin-top:30px;display:flex;justify-content:space-between;}
.page-break{page-break-after:always;}

@media print{
    @page{size:A4 portrait;margin:20mm}
}
</style>
</head>
<body onload="window.print()">

<?php foreach($siswa_list as $idx=>$siswa): ?>

<?php
/* Ambil nilai siswa per mapel */
$qNilai = mysqli_query($conn,"
SELECT m.nama_mapel, h.nilai
FROM smart_cbt.hasil h
JOIN smart_cbt.ujian u ON u.id=h.id_ujian
LEFT JOIN pkbm_taruna_qurani.mapel m ON m.id=u.id_mapel
WHERE h.id_siswa='{$siswa['id']}'
ORDER BY m.nama_mapel
");
$total_nilai = 0;
$mapel_count = 0;
?>

<div class="kop">
    <img src="../assets/logo/<?= $logo ?>">
    <h3><?= $nama_sekolah ?></h3>
    <p><?= $alamat ?></p>
    <div class="clear"></div>
</div>

<h4 style="text-align:center;margin:5px 0 15px">LAPORAN HASIL BELAJAR (RAPORT NILAI)</h4>

<table class="identitas">
<tr>
<td width="18%">Nama</td><td width="2%">:</td><td width="30%"><?= $siswa['nama'] ?></td>
<td width="18%">Kelas</td><td width="2%">:</td><td><?= $kelas_nama ?></td>
</tr>
<tr>
<td>NISN</td><td>:</td><td><?= $siswa['nisn'] ?></td>
<td>Semester</td><td>:</td><td><?= date('Y') ?></td>
</tr>
</table>

<br>

<table>
<thead>
<tr>
<th width="5%">No</th>
<th>Nama Mata Pelajaran</th>
<th width="15%">Nilai</th>
<th width="20%">Predikat</th>
</tr>
</thead>
<tbody>
<?php 
$no=1;
while($n=mysqli_fetch_assoc($qNilai)):
$nilai=(int)$n['nilai'];
$total_nilai += $nilai;
$mapel_count++;

if($nilai>=90) $pred='A (Sangat Baik)';
elseif($nilai>=80) $pred='B (Baik)';
elseif($nilai>=70) $pred='C (Cukup)';
else $pred='D (Kurang)';
?>
<tr>
<td><?= $no++ ?></td>
<td><?= $n['nama_mapel'] ?></td>
<td><?= $nilai ?></td>
<td><?= $pred ?></td>
</tr>
<?php endwhile; ?>

<?php if($no==1): ?>
<tr><td colspan="4">Belum ada nilai</td></tr>
<?php endif; ?>
</tbody>
</table>

<?php if($mapel_count>0): ?>
<p>Rata-rata: <b><?= round($total_nilai/$mapel_count,2) ?></b></p>
<?php endif; ?>

<div class="ttd">
<div>
Mengetahui,<br>
Kepala Sekolah<br><br><br><br>
( ______________________ )
</div>

<div>
<?= date('d F Y') ?><br>
Wali Kelas<br><br><br><br>
( ______________________ )
</div>
</div>

<?php if($idx < count($siswa_list)-1): ?>
<div class="page-break"></div>
<?php endif; ?>

<?php endforeach; ?>

</body>
</html>
