<?php
require __DIR__ . '/../config/database.php';
if (session_status() === PHP_SESSION_NONE) session_start();

/* ===== PROTEKSI ===== */
if (empty($_SESSION['login']) || ($_SESSION['user']['role'] ?? '') !== 'admin') {
    exit('Akses ditolak');
}

/* ===== HEADER EXCEL ===== */
header("Content-Type: application/vnd.ms-excel");
header("Content-Disposition: attachment; filename=hasil_nilai.xls");
header("Pragma: no-cache");
header("Expires: 0");

/* ===== FILTER ===== */
$kelas = $_GET['kelas'] ?? '';
$siswa = $_GET['siswa'] ?? '';
$mapel = $_GET['mapel'] ?? '';

$where=[];
if($kelas) $where[]="s.kelas='".mysqli_real_escape_string($conn,$kelas)."'";
if($siswa) $where[]="s.id=".(int)$siswa;
if($mapel) $where[]="m.id=".(int)$mapel;
$whereSQL=$where?"WHERE ".implode(" AND ",$where):"";

/* ===== QUERY ===== */
$sql="
SELECT
 s.id AS id_siswa,
 s.nisn,
 s.nama,
 s.kelas,
 m.nama_mapel,
 h.nilai
FROM hasil h
JOIN siswa s ON s.id=h.id_siswa
JOIN ujian u ON u.id=h.id_ujian
LEFT JOIN mapel m ON m.id=u.id_mapel
$whereSQL
ORDER BY s.nama,m.nama_mapel
";
$q=mysqli_query($conn,$sql);

/* ===== STYLE ===== */
echo "
<html>
<head>
<style>
@page{size:A4;margin:20mm}
body{font-family:Calibri,Arial;font-size:12pt}
.header{text-align:center;font-weight:bold;font-size:15pt}
.subheader{text-align:center;font-size:11pt}
.line{border-bottom:2px solid #000;margin:6px 0 12px}
table.info{font-size:12pt}
table.info td{padding:3px 6px}
.table{width:100%;border-collapse:collapse}
.table th,.table td{border:1px solid #000;padding:6px}
.table th{background:#f2f2f2}
.footer{margin-top:40px;text-align:right}
.page-break{page-break-after:always}
</style>
</head>
<body>
";

$last=null;
$no=1;

while($r=mysqli_fetch_assoc($q)){

if($last!==$r['id_siswa']){

if($last!==null){
echo "</table>
<div class='footer'>Pengawas<br><br>(...........................)</div>
</div>
<div class='page-break'></div>";
}

$nama  = htmlspecialchars($r['nama']);
$nisn  = htmlspecialchars($r['nisn']);
$kelas = htmlspecialchars($r['kelas']);

echo "


<table class='info'>
<tr><td width='80'>Nama</td><td width='10'>:</td><td><b>$nama</b></td></tr>
<tr><td>NISN</td><td>:</td><td>$nisn</td></tr>
<tr><td>Kelas</td><td>:</td><td>$kelas</td></tr>
</table><br>

<table class='table'>
<tr>
<th width='50'>No</th>
<th>Mata Pelajaran</th>
<th width='80'>Nilai</th>
</tr>
";

$no=1;
$last=$r['id_siswa'];
}

$mapel = htmlspecialchars($r['nama_mapel']);
$nilai = (int)$r['nilai'];

echo "
<tr>
<td align='center'>$no</td>
<td>$mapel</td>
<td align='center'><b>$nilai</b></td>
</tr>
";
$no++;
}

if($last!==null){
echo "</table>
<div class='footer'>Pengawas<br><br>(...........................)</div>
</div>";
}

echo "</body></html>";
?>
