<?php
require 'init.php';

$siswa = mysqli_query($conn,"
    SELECT s.*, k.nama_kelas 
    FROM siswa s 
    JOIN kelas k ON s.id_kelas=k.id
    ORDER BY nama
");
?>
<!doctype html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Cetak Kartu Ujian</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

<style>
@media print {
  .no-print { display:none }
}
.card-ujian {
  width: 8.5cm;
  height: 5.5cm;
  border:1px solid #000;
  padding:8px;
  font-size:11px;
}
.logo { width:40px }
</style>
</head>
<body>

<div class="container">
<button onclick="window.print()" class="btn btn-primary mb-3 no-print">
🖨 Cetak Semua
</button>

<div class="row g-3">

<?php while($s=mysqli_fetch_assoc($siswa)): ?>
<div class="col-md-4">
<div class="card-ujian">
<div class="d-flex align-items-center mb-1">
<img src="../assets/logo/logo.png" class="logo me-2">
<strong>KARTU UJIAN CBT</strong>
</div>

<table class="table table-sm table-borderless mb-1">
<tr><td>Nama</td><td>: <?= $s['nama'] ?></td></tr>
<tr><td>NISN</td><td>: <?= $s['nisn'] ?></td></tr>
<tr><td>Kelas</td><td>: <?= $s['nama_kelas'] ?></td></tr>
<tr><td>User</td><td>: <?= $s['username'] ?></td></tr>
<tr><td>Pass</td><td>: <?= $s['password'] ?></td></tr>
</table>

<img src="https://api.qrserver.com/v1/create-qr-code/?size=80x80&data=<?= $s['nisn'] ?>">
</div>
</div>
<?php endwhile; ?>

</div>
</div>
</body>
</html>
