<?php
require __DIR__ . '/../config/database.php';

/* ================= SESSION ADMIN ================= */
if (session_status() === PHP_SESSION_NONE) session_start();
if (
    empty($_SESSION['login']) ||
    empty($_SESSION['user']) ||
    $_SESSION['user']['role'] !== 'admin'
) die('Akses ditolak');

/* ================= VALIDASI UJIAN ================= */
$ujian_id = (int)($_GET['ujian_id'] ?? 0);
if ($ujian_id <= 0) die('Ujian tidak valid');

$qUjian = mysqli_query($conn,"
    SELECT u.*, p.nama_paket
    FROM ujian u
    JOIN paket_ujian p ON p.id=u.id_paket
    WHERE u.id=$ujian_id
    LIMIT 1
");
if (mysqli_num_rows($qUjian) == 0) die('Ujian tidak ditemukan');
$ujian = mysqli_fetch_assoc($qUjian);

/* ================= PROFIL SEKOLAH (AUTO DETEKSI) ================= */
$nama_aplikasi = 'SMART CBT';
$nama_sekolah  = 'SEKOLAH';
$logo          = 'default.png';

$tables = ['profil_sekolah','profil_aplikasi','setting','sekolah'];
foreach ($tables as $t) {
    $cek = mysqli_query($conn,"SHOW TABLES LIKE '$t'");
    if ($cek && mysqli_num_rows($cek)) {
        $q = mysqli_query($conn,"SELECT * FROM `$t` LIMIT 1");
        if ($q && mysqli_num_rows($q)) {
            $s = mysqli_fetch_assoc($q);
            $nama_aplikasi = $s['nama_aplikasi'] ?? $nama_aplikasi;
            $nama_sekolah  = $s['nama_sekolah']  ?? $nama_sekolah;
            $logo          = $s['logo']          ?? $logo;
        }
        break;
    }
}

if (!file_exists(__DIR__."/../assets/logo/$logo")) {
    $logo = 'default.png';
}


/* ================= FOLDER UPLOAD ================= */
$dirImg="../uploads/soal/img/";
$dirAud="../uploads/soal/audio/";
if(!is_dir($dirImg)) mkdir($dirImg,0777,true);
if(!is_dir($dirAud)) mkdir($dirAud,0777,true);

/* ================= IMPORT EXCEL / CSV ================= */
if(isset($_POST['import'])){
    $file = fopen($_FILES['file']['tmp_name'], 'r');
    $no = 0;

    while(($row = fgetcsv($file, 2000, ',')) !== false){
        if($no++ === 0) continue; // skip header

        $tipe = strtolower(trim($row[0] ?? 'pg'));
        $soal = mysqli_real_escape_string($conn, trim($row[1] ?? ''));

        if($tipe === 'essay'){
            // ESSAY
            $a = $b = $c = $d = $e = '';
            $kunci = mysqli_real_escape_string($conn, trim($row[7] ?? ''));
        } else {
            // PILIHAN GANDA
            $tipe = 'pg';
            $a = mysqli_real_escape_string($conn, trim($row[2] ?? ''));
            $b = mysqli_real_escape_string($conn, trim($row[3] ?? ''));
            $c = mysqli_real_escape_string($conn, trim($row[4] ?? ''));
            $d = mysqli_real_escape_string($conn, trim($row[5] ?? ''));
            $e = mysqli_real_escape_string($conn, trim($row[6] ?? ''));
            $kunci = strtoupper(trim($row[7] ?? ''));
        }

        if($soal !== ''){
            mysqli_query($conn, "
                INSERT INTO soal
                (id_ujian, tipe, soal, a, b, c, d, e, kunci)
                VALUES
                ($ujian_id, '$tipe', '$soal', '$a', '$b', '$c', '$d', '$e', '$kunci')
            ");
        }
    }

    fclose($file);
    header("Location: soal.php?ujian_id=$ujian_id");
    exit;
}


/* ================= TAMBAH / EDIT ================= */
if(isset($_POST['simpan'])){
    $id   = (int)($_POST['id'] ?? 0);
    $tipe = $_POST['tipe'];
    $soal = mysqli_real_escape_string($conn,$_POST['soal']);

    if($tipe === 'essay'){
        // ESSAY → tidak ada opsi PG
        $a = $b = $c = $d = $e = '';
        $kunci = mysqli_real_escape_string($conn, $_POST['kunci_essay'] ?? '');
    } else {
        // PILIHAN GANDA
        $a = mysqli_real_escape_string($conn,$_POST['a'] ?? '');
        $b = mysqli_real_escape_string($conn,$_POST['b'] ?? '');
        $c = mysqli_real_escape_string($conn,$_POST['c'] ?? '');
        $d = mysqli_real_escape_string($conn,$_POST['d'] ?? '');
        $e = mysqli_real_escape_string($conn,$_POST['e'] ?? '');
        $kunci = strtoupper($_POST['kunci'] ?? '');
    }

    $gambar=''; $audio='';

    if(!empty($_FILES['gambar']['name'])){
        $gambar=time().'_'.$_FILES['gambar']['name'];
        move_uploaded_file($_FILES['gambar']['tmp_name'],$dirImg.$gambar);
    }
    if(!empty($_FILES['audio']['name'])){
        $audio=time().'_'.$_FILES['audio']['name'];
        move_uploaded_file($_FILES['audio']['tmp_name'],$dirAud.$audio);
    }

    if($id==0){
        mysqli_query($conn,"
            INSERT INTO soal
            (id_ujian,tipe,soal,a,b,c,d,e,kunci,gambar,audio)
            VALUES
            ($ujian_id,'$tipe','$soal','$a','$b','$c','$d','$e','$kunci','$gambar','$audio')
        ");
    }else{
        mysqli_query($conn,"
            UPDATE soal SET
            tipe='$tipe',
            soal='$soal',
            a='$a',b='$b',c='$c',d='$d',e='$e',
            kunci='$kunci',
            gambar=IF('$gambar'='',gambar,'$gambar'),
            audio=IF('$audio'='',audio,'$audio')
            WHERE id=$id AND id_ujian=$ujian_id
        ");
    }
    header("Location: soal.php?ujian_id=$ujian_id"); exit;
}

/* ================= HAPUS ================= */
if(isset($_GET['hapus'])){
    mysqli_query($conn,"
        DELETE FROM soal
        WHERE id=".(int)$_GET['hapus']." AND id_ujian=$ujian_id
    ");
    header("Location: soal.php?ujian_id=$ujian_id"); exit;
}

/* ================= DATA ================= */
$data=mysqli_query($conn,"
    SELECT * FROM soal
    WHERE id_ujian=$ujian_id
    ORDER BY id DESC
");
?>
<!doctype html>
<html lang="id">
<head>
<meta charset="utf-8">
<title>Bank Soal</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">
<style>
body{background:#f4f6f9}
.sidebar{width:260px;min-height:100vh;background:#1f2937;color:#fff;position:fixed}
.brand{padding:16px;background:#111827;display:flex;gap:12px;align-items:center}
.brand img{width:36px}
.sidebar a{color:#cbd5e1;padding:10px 16px;display:block;text-decoration:none}
.sidebar a:hover,.sidebar a.active{background:#2563eb;color:#fff}
.content{margin-left:260px;padding:24px}
</style>
</head>
<body>

<!-- SIDEBAR SAMA SEPERTI PAKET -->
<div class="sidebar">
<div class="brand">
<img src="../assets/logo/<?= $logo ?>">
<div>
<b><?= $nama_aplikasi ?></b><br>
<small><?= $nama_sekolah ?></small>
</div>
</div>
<a href="dashboard.php">Dashboard</a>
<a href="paket.php">Paket Ujian</a>
<a href="ujian.php" class="active">Ujian</a>
<a href="../auth/logout.php">Logout</a>
</div>

<div class="content">
<h4>📄 Bank Soal</h4>
<div class="text-muted mb-3">
Paket: <b><?= $ujian['nama_paket'] ?></b> |
Ujian: <b><?= $ujian['nama_ujian'] ?></b>
</div>

<button class="btn btn-success btn-sm" data-bs-toggle="modal" data-bs-target="#modalSoal">
<i class="bi bi-plus"></i> Tambah Soal
</button>

<button class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#modalImport">
<i class="bi bi-upload"></i> Import Excel
</button>

<a href="../assets/excel/template_soal.xlsx"
   class="btn btn-outline-success btn-sm"
   download>
<i class="bi bi-download"></i> Download Template
</a>


<table class="table table-bordered bg-white mt-3">
<thead class="table-dark">
<tr>
<th>#</th>
<th>Soal</th>
<th>Tipe</th>
<th width="120">Aksi</th>
</tr>
</thead>
<tbody>
<?php $no=1; while($s=mysqli_fetch_assoc($data)): ?>
<tr>
<td><?= $no++ ?></td>
<td>
<?= $s['soal'] ?>
<?php if($s['gambar']): ?>
<br><img src="../uploads/soal/img/<?= $s['gambar'] ?>" width="120">
<?php endif ?>
<?php if($s['audio']): ?>
<br><audio controls src="../uploads/soal/audio/<?= $s['audio'] ?>"></audio>
<?php endif ?>
</td>
<td><?= strtoupper($s['tipe']) ?></td>
<td>
    <button
class="btn btn-warning btn-sm btn-edit"
data-id="<?= $s['id'] ?>"
data-tipe="<?= $s['tipe'] ?>"
data-soal="<?= htmlspecialchars($s['soal'],ENT_QUOTES) ?>"
data-a="<?= htmlspecialchars($s['a'],ENT_QUOTES) ?>"
data-b="<?= htmlspecialchars($s['b'],ENT_QUOTES) ?>"
data-c="<?= htmlspecialchars($s['c'],ENT_QUOTES) ?>"
data-d="<?= htmlspecialchars($s['d'],ENT_QUOTES) ?>"
data-e="<?= htmlspecialchars($s['e'],ENT_QUOTES) ?>"
data-kunci="<?= htmlspecialchars($s['kunci'],ENT_QUOTES) ?>"
data-bs-toggle="modal"
data-bs-target="#modalSoal">
<i class="bi bi-pencil"></i>
</button>

<a href="?ujian_id=<?= $ujian_id ?>&hapus=<?= $s['id'] ?>"
class="btn btn-danger btn-sm"
onclick="return confirm('Hapus soal?')">
<i class="bi bi-trash"></i>
</a>
</td>
</tr>
<?php endwhile ?>
</tbody>
</table>
</div>

<!-- MODAL SOAL -->
<div class="modal fade" id="modalSoal">
<div class="modal-dialog modal-lg">
<form method="post" enctype="multipart/form-data" class="modal-content">
<div class="modal-header">
<h5 id="judulModal">Tambah Soal</h5>
<button class="btn-close" data-bs-dismiss="modal"></button>
</div>

<div class="modal-body">

<input type="hidden" name="id" id="id_soal">

<select name="tipe" id="tipe" class="form-select mb-2">
<option value="pg">Pilihan Ganda</option>
<option value="essay">Essay</option>
</select>

<textarea name="soal" id="soal" class="form-control mb-2" required></textarea>

<!-- OPSI PG -->
<div id="opsi_pg">
<input name="a" id="a" class="form-control mb-1" placeholder="Jawaban A">
<input name="b" id="b" class="form-control mb-1" placeholder="Jawaban B">
<input name="c" id="c" class="form-control mb-1" placeholder="Jawaban C">
<input name="d" id="d" class="form-control mb-1" placeholder="Jawaban D">
<input name="e" id="e" class="form-control mb-1" placeholder="Jawaban E">

<select name="kunci" id="kunci_pg" class="form-select mb-2">
<option value="">-- Kunci PG --</option>
<option>A</option><option>B</option><option>C</option>
<option>D</option><option>E</option>
</select>
</div>

<!-- ESSAY -->
<textarea
name="kunci_essay"
id="kunci_essay"
class="form-control mb-2"
placeholder="Kunci jawaban essay (opsional)">
</textarea>

<label>Gambar</label>
<input type="file" name="gambar" class="form-control mb-2">

<label>Audio</label>
<input type="file" name="audio" class="form-control">

</div>

<div class="modal-footer">
<button name="simpan" class="btn btn-success">Simpan</button>
</div>

</form>
</div>
</div>

<!-- MODAL IMPORT -->
<div class="modal fade" id="modalImport">
<div class="modal-dialog">
<form method="post" enctype="multipart/form-data" class="modal-content">
<div class="modal-header">
<h5>Import Excel</h5>
<button class="btn-close" data-bs-dismiss="modal"></button>
</div>
<div class="modal-body">
<input type="file" name="file" class="form-control" required>
<small class="text-muted">
Format: tipe, soal, A, B, C, D, E, kunci
</small>
</div>
<div class="modal-footer">
<button name="import" class="btn btn-primary">Import</button>
</div>
</form>
</div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function () {

const modal = document.getElementById('modalSoal');
const tipe  = document.getElementById('tipe');
const opsiPG = document.getElementById('opsi_pg');
const kunciPG = document.getElementById('kunci_pg');
const essay = document.getElementById('kunci_essay');

function toggle(){
    if(tipe.value === 'essay'){
        opsiPG.style.display = 'none';
        essay.style.display = 'block';
        kunciPG.value = '';
    }else{
        opsiPG.style.display = 'block';
        essay.style.display = 'none';
        essay.value = '';
    }
}

tipe.addEventListener('change', toggle);

document.querySelectorAll('.btn-edit').forEach(btn=>{
    btn.addEventListener('click', function(){
        document.getElementById('judulModal').innerText = 'Edit Soal';
        document.getElementById('id_soal').value = this.dataset.id;
        tipe.value = this.dataset.tipe;
        document.getElementById('soal').value = this.dataset.soal;
        document.getElementById('a').value = this.dataset.a;
        document.getElementById('b').value = this.dataset.b;
        document.getElementById('c').value = this.dataset.c;
        document.getElementById('d').value = this.dataset.d;
        document.getElementById('e').value = this.dataset.e;

        if(this.dataset.tipe === 'essay'){
            essay.value = this.dataset.kunci;
        }else{
            kunciPG.value = this.dataset.kunci;
        }
        toggle();
    });
});

modal.addEventListener('hidden.bs.modal', ()=>{
    modal.querySelector('form').reset();
    document.getElementById('id_soal').value = '';
    document.getElementById('judulModal').innerText = 'Tambah Soal';
    toggle();
});

toggle();
});
</script>


</body>
</html>
