<?php
session_start();

/*
|--------------------------------------------------------------------------
| BLOK JIKA SUDAH INSTALL
|--------------------------------------------------------------------------
*/
if (file_exists(__DIR__ . '/install.lock')) {
    header("Location: ../auth/login.php");
    exit;
}

/*
|--------------------------------------------------------------------------
| CEK STEP (WAJIB SUDAH STEP 2)
|--------------------------------------------------------------------------
*/
if (!isset($_SESSION['step']) || $_SESSION['step'] < 2) {
    header("Location: database.php");
    exit;
}

/*
|--------------------------------------------------------------------------
| PROSES SUBMIT ADMIN
|--------------------------------------------------------------------------
*/
if (isset($_POST['next'])) {

    if ($_POST['pass'] !== $_POST['repass']) {
        $error = "Password tidak sama!";
    } else {

        $_SESSION['admin'] = [
            'nama' => trim($_POST['nama']),
            'user' => trim($_POST['user']),
            'pass' => password_hash($_POST['pass'], PASSWORD_DEFAULT)
        ];

        $_SESSION['step'] = 3;
        header("Location: sekolah.php");
        exit;
    }
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Install Aplikasi</title>
<meta name="viewport" content="width=device-width, initial-scale=1">

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

<style>
body{background:#f4f6f9;}
.card{border-radius:12px;}
.stepper{
  display:flex;
  justify-content:space-between;
  margin-bottom:30px;
  position:relative;
}
.stepper::before{
  content:'';
  position:absolute;
  top:12px;
  left:0;
  right:0;
  height:2px;
  background:#e0e0e0;
}
.step{
  position:relative;
  text-align:center;
  width:100%;
}
.step span{
  width:24px;
  height:24px;
  background:#20c997;
  color:#fff;
  border-radius:50%;
  display:inline-flex;
  align-items:center;
  justify-content:center;
  font-size:13px;
}
.step.inactive span{background:#ced4da;}
.step label{display:block;font-size:13px;margin-top:6px;}
.footer{font-size:12px;color:#6c757d;}
</style>
</head>

<body>
<div class="container mt-5">
  <div class="card shadow-sm p-4">

    <h5 class="text-center mb-4">Install Aplikasi</h5>

    <!-- STEPPER -->
    <div class="stepper">
      <div class="step"><span>✓</span><label>Database</label></div>
      <div class="step"><span>2</span><label>Administrator</label></div>
      <div class="step inactive"><span>3</span><label>Sekolah</label></div>
      <div class="step inactive"><span>4</span><label>Selesai</label></div>
    </div>

    <h6 class="text-center fw-bold mb-4">LOGIN ADMINISTRATOR</h6>

    <?php if(isset($error)): ?>
      <div class="alert alert-danger text-center">
        <?= $error ?>
      </div>
    <?php endif; ?>

    <!-- FORM ADMIN -->
    <form method="post">
      <div class="row g-3">

        <div class="col-md-6">
          <label class="form-label">Nama Lengkap</label>
          <input type="text" name="nama" class="form-control" required>
        </div>

        <div class="col-md-6">
          <label class="form-label">Username</label>
          <input type="text" name="user" class="form-control" required>
        </div>

        <div class="col-md-6">
          <label class="form-label">Password</label>
          <input type="password" name="pass" class="form-control" minlength="6" required>
          <small class="text-muted">Password minimal 6 karakter</small>
        </div>

        <div class="col-md-6">
          <label class="form-label">Ulangi Password</label>
          <input type="password" name="repass" class="form-control" minlength="6" required>
        </div>

      </div>

      <div class="d-flex justify-content-between mt-4">
        <a href="database.php" class="btn btn-outline-secondary px-4">
          SEBELUMNYA
        </a>
        <button type="submit" name="next" class="btn btn-success px-4">
          SELANJUTNYA
        </button>
      </div>

      <div class="text-center footer mt-3">
        Dikembangkan oleh <b>Bang Zae</b>
      </div>
    </form>

  </div>
</div>
</body>
</html>
