<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

require __DIR__ . '/../config/database.php';

/* ================= KONEKSI PKBM ================= */
$conn2 = mysqli_connect("localhost","root","","pkbm_taruna_qurani");
if(!$conn2){
    die("Koneksi database PKBM gagal: ".mysqli_connect_error());
}

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

/* ================= PROTEKSI ================= */
if (
    empty($_SESSION['login_siswa']) ||
    empty($_SESSION['siswa']['id'])
) {
    header("Location: ../auth/login_siswa.php");
    exit;
}

$id = (int) $_SESSION['siswa']['id'];

/* ================= PROFIL SEKOLAH ================= */
$nama_sekolah = 'SEKOLAH';
$logo = 'default.png';

$q = mysqli_query($conn,"SELECT nama_sekolah, logo FROM sekolah LIMIT 1");
if ($q && mysqli_num_rows($q)) {
    $sc = mysqli_fetch_assoc($q);
    $nama_sekolah = $sc['nama_sekolah'] ?? $nama_sekolah;
    $logo = $sc['logo'] ?? $logo;
}
if (!file_exists(__DIR__ . "/../assets/logo/$logo")) {
    $logo = 'default.png';
}

/* ================= DATA SISWA (PKBM) ================= */
$stmt = mysqli_prepare($conn2,"
    SELECT 
        s.nisn,
        s.nama,
        s.tanggal_lahir,
        s.kelas_id,
        k.nama_kelas,
        k.paket_id
    FROM siswa s
    LEFT JOIN kelas k ON k.id = s.kelas_id
    WHERE s.id=?
    LIMIT 1
");
mysqli_stmt_bind_param($stmt,"i",$id);
mysqli_stmt_execute($stmt);
$res = mysqli_stmt_get_result($stmt);

if (!$res || mysqli_num_rows($res) !== 1) {
    session_destroy();
    header("Location: ../auth/login_siswa.php");
    exit;
}
$s = mysqli_fetch_assoc($res);
mysqli_stmt_close($stmt);

/* ================= FORMAT KELAS ================= */
$paket = !empty($s['paket_id']) ? chr(64 + (int)$s['paket_id']) : '';
$kelas_full = trim(($s['nama_kelas'] ?? '').'-'.$paket,'-');

/* ================= UPDATE STATUS LOGIN ================= */
mysqli_query($conn,"
    UPDATE login_siswa
    SET status='login',
        last_active=NOW()
    WHERE id = (
        SELECT id FROM (
            SELECT id FROM login_siswa
            WHERE id_siswa=$id
            ORDER BY id DESC
            LIMIT 1
        ) x
    )
");

/* ================= UJIAN AKTIF ================= */
$ujian_aktif = '-';
$id_ujian_aktif = 0;

$stmt2 = mysqli_prepare($conn,"
    SELECT id, nama_ujian
    FROM ujian
    WHERE id_kelas=?
      AND status='Aktif'
    LIMIT 1
");
mysqli_stmt_bind_param($stmt2,"i",$s['kelas_id']);
mysqli_stmt_execute($stmt2);
$res2 = mysqli_stmt_get_result($stmt2);

if ($res2 && mysqli_num_rows($res2)) {
    $u = mysqli_fetch_assoc($res2);
    $ujian_aktif = $u['nama_ujian'];
    $id_ujian_aktif = (int)$u['id'];
}
mysqli_stmt_close($stmt2);

$ujian_ready = ($id_ujian_aktif > 0);
?>
<!doctype html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Biodata Peserta</title>
<meta name="viewport" content="width=device-width, initial-scale=1">

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

<style>
body{
    background:#f1f5f9;
}
.card{
    border-radius:18px;
}
.logo{
    width:80px;
}
</style>
</head>

<body>

<div class="container py-4">
<div class="row justify-content-center">
<div class="col-lg-6">

<div class="card shadow">
<div class="card-body p-4">

<div class="text-center mb-3">
    <img src="../assets/logo/<?= htmlspecialchars($logo) ?>" class="logo mb-2">
    <h6 class="fw-bold mb-0"><?= htmlspecialchars($nama_sekolah) ?></h6>
    <small class="text-muted">Sistem Ujian Berbasis Komputer</small>
</div>

<hr>

<h5 class="fw-bold text-center mb-4">📄 BIODATA PESERTA</h5>

<table class="table table-bordered table-sm">
<tr>
    <th width="40%">NISN</th>
    <td><?= htmlspecialchars($s['nisn']) ?></td>
</tr>
<tr>
    <th>Nama</th>
    <td><?= htmlspecialchars($s['nama']) ?></td>
</tr>
<tr>
    <th>Kelas</th>
    <td><?= htmlspecialchars($kelas_full ?: '-') ?></td>
</tr>
<tr>
    <th>Tanggal Lahir</th>
    <td>
        <?= (!empty($s['tanggal_lahir']) && $s['tanggal_lahir']!='0000-00-00')
            ? date('d-m-Y',strtotime($s['tanggal_lahir']))
            : '-' ?>
    </td>
</tr>
<tr class="table-info">
    <th>Ujian Aktif</th>
    <td class="fw-bold text-primary"><?= htmlspecialchars($ujian_aktif) ?></td>
</tr>
</table>

<form method="post" action="cek_token.php" autocomplete="off">

<input type="hidden" name="id_ujian" value="<?= $id_ujian_aktif ?>">

<input type="text"
       name="token"
       class="form-control text-center fw-bold mb-3"
       placeholder="MASUKKAN TOKEN UJIAN"
       required <?= $ujian_ready ? '' : 'disabled' ?>>

<button class="btn btn-success w-100 btn-lg"
        <?= $ujian_ready ? '' : 'disabled' ?>>
▶ MULAI UJIAN
</button>

<?php if(!$ujian_ready): ?>
<div class="alert alert-warning text-center mt-3">
Belum ada ujian aktif untuk kelas Anda
</div>
<?php endif; ?>

</form>

</div>
</div>

</div>
</div>
</div>

</body>
</html>
