<?php
session_start();
require __DIR__ . '/../config/database.php';

/* ================== PROTEKSI ================== */
if (
    empty($_SESSION['login_siswa']) ||
    empty($_SESSION['siswa']['id']) ||
    empty($_SESSION['ujian']['id_ujian'])
) {
    header("Location: biodata_siswa.php");
    exit;
}

$id_siswa = (int) $_SESSION['siswa']['id'];
$id_ujian = (int) $_SESSION['ujian']['id_ujian'];

/* ================== CEK STATUS ================== */
$qcek = mysqli_query($conn,"
    SELECT status 
    FROM login_siswa
    WHERE id_siswa=$id_siswa AND id_ujian=$id_ujian
    LIMIT 1
");
$st = mysqli_fetch_assoc($qcek);
if ($st && $st['status'] === 'selesai') {
    die('Ujian sudah diselesaikan.');
}

/* ================== SIMPAN JAWABAN PG ================== */
if (!empty($_POST['jawaban']) && is_array($_POST['jawaban'])) {

    foreach ($_POST['jawaban'] as $id_soal => $huruf_tampil) {

        $id_soal      = (int)$id_soal;
        $huruf_tampil = strtoupper(trim($huruf_tampil));
        if (!$id_soal || $huruf_tampil === '') continue;

        // mapping opsi acak
        $q = mysqli_query($conn,"
            SELECT huruf_asli
            FROM acak_opsi
            WHERE id_siswa=$id_siswa
              AND id_soal=$id_soal
              AND huruf_tampil='$huruf_tampil'
            LIMIT 1
        ");
        $map = mysqli_fetch_assoc($q);
        if (!$map) continue;

        $kolom = ['a','b','c','d'];
        $idx = (int)$map['huruf_asli'];
        if (!isset($kolom[$idx])) continue;
        $col = $kolom[$idx];

        // ambil isi jawaban
        $s = mysqli_query($conn,"
            SELECT `$col` AS isi
            FROM soal
            WHERE id=$id_soal
            LIMIT 1
        ");
        $d = mysqli_fetch_assoc($s);
        if (!$d || trim($d['isi']) === '') continue;

        $isi = mysqli_real_escape_string($conn, trim($d['isi']));

        mysqli_query($conn,"
            INSERT INTO jawaban
                (id_ujian,id_siswa,id_soal,tipe,jawaban_pg,dibuat)
            VALUES
                ($id_ujian,$id_siswa,$id_soal,'pg','$isi',NOW())
            ON DUPLICATE KEY UPDATE
                jawaban_pg='$isi',
                tipe='pg',
                dibuat=NOW()
        ");
    }
}

/* ================== SIMPAN JAWABAN ESSAY ================== */
if (!empty($_POST['jawaban_essay']) && is_array($_POST['jawaban_essay'])) {

    foreach ($_POST['jawaban_essay'] as $id_soal => $essay) {

        $id_soal = (int)$id_soal;
        $essay   = trim($essay);
        if ($essay === '') continue;

        $essay = mysqli_real_escape_string($conn,$essay);

        mysqli_query($conn,"
            INSERT INTO jawaban
                (id_ujian,id_siswa,id_soal,tipe,jawaban_essay,dibuat)
            VALUES
                ($id_ujian,$id_siswa,$id_soal,'essay','$essay',NOW())
            ON DUPLICATE KEY UPDATE
                jawaban_essay='$essay',
                tipe='essay',
                dibuat=NOW()
        ");
    }
}

/* ================== HITUNG NILAI PG (FINAL) ================== */
$benar = 0;
$total = 0;

$q = mysqli_query($conn,"
    SELECT 
        j.jawaban_pg,
        s.kunci,
        s.a, s.b, s.c, s.d
    FROM jawaban j
    JOIN soal s ON s.id=j.id_soal
    WHERE j.id_siswa=$id_siswa
      AND j.id_ujian=$id_ujian
      AND j.tipe='pg'
");

while ($r = mysqli_fetch_assoc($q)) {
    $total++;

    $kunci = strtoupper(trim($r['kunci']));
    $isi_kunci = '';

    if ($kunci === 'A') $isi_kunci = trim($r['a']);
    elseif ($kunci === 'B') $isi_kunci = trim($r['b']);
    elseif ($kunci === 'C') $isi_kunci = trim($r['c']);
    elseif ($kunci === 'D') $isi_kunci = trim($r['d']);

    if ($isi_kunci !== '' && strcasecmp(trim($r['jawaban_pg']), $isi_kunci) === 0) {
        $benar++;
    }
}

$nilai = ($total > 0) ? round(($benar / $total) * 100) : 0;

/* ================== SIMPAN HASIL ================== */
mysqli_query($conn,"
    INSERT INTO hasil (id_siswa,id_ujian,nilai,selesai)
    VALUES ($id_siswa,$id_ujian,$nilai,NOW())
    ON DUPLICATE KEY UPDATE
        nilai=$nilai,
        selesai=NOW()
");

/* ================== UPDATE STATUS ================== */
mysqli_query($conn,"
    UPDATE login_siswa
    SET status='selesai', last_active=NOW()
    WHERE id_siswa=$id_siswa AND id_ujian=$id_ujian
");

/* ================== BERSIHKAN SESSION ================== */
unset($_SESSION['ujian']);
$_SESSION['ujian_selesai'] = true;
?>
<!doctype html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Ujian Selesai</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">

<div class="container mt-5" style="max-width:460px">
<div class="card shadow text-center">
<div class="card-body p-4">

<h4 class="fw-bold text-success mb-3">✅ UJIAN TELAH SELESAI</h4>
<p>Jawaban dan nilai berhasil disimpan.</p>

<a href="logout.php" class="btn btn-danger w-100 fw-bold">
KELUAR
</a>

</div>
</div>
</div>

</body>
</html>
