<?php
require '../../edu_digital/config/database.php';

$siswa_id = intval($_GET['siswa'] ?? 0);

$stmt = $conn->prepare("
    SELECT 
        t.id,
        t.bulan,
        t.nominal,
        IFNULL(SUM(p.jumlah_bayar),0) as total_bayar
    FROM spp_tagihan t
    LEFT JOIN spp_pembayaran p ON p.tagihan_id = t.id
    WHERE t.siswa_id = ?
    GROUP BY t.id
    ORDER BY FIELD(t.bulan,
        'Januari','Februari','Maret','April','Mei','Juni',
        'Juli','Agustus','September','Oktober','November','Desember')
");
$stmt->bind_param("i",$siswa_id);
$stmt->execute();
$data = $stmt->get_result();

echo "<div data-siswa='{$siswa_id}'>";
echo "<table width='100%' cellpadding='8' style='border-collapse:collapse'>";

echo "<tr style='background:#f8f9fc'>
<th>Bulan</th>
<th>Nominal</th>
<th>Terbayar</th>
<th>Sisa</th>
<th>Status</th>
<th>Aksi</th>
</tr>";

while($row = $data->fetch_assoc()){

    $id = (int)$row['id'];
    $nominal = (int)$row['nominal'];
    $totalBayar = (int)$row['total_bayar'];

    $sisa = $nominal - $totalBayar;
    if($sisa < 0) $sisa = 0;

    $status = ($sisa == 0) ? 'Lunas' : 'Belum';

    echo "<tr style='border-bottom:1px solid #eee'>";
    echo "<td>{$row['bulan']}</td>";
    echo "<td style='white-space:nowrap'>Rp&nbsp;".number_format($nominal,0,',','.')."</td>";
    echo "<td style='white-space:nowrap'>Rp&nbsp;".number_format($totalBayar,0,',','.')."</td>";
    echo "<td style='white-space:nowrap'>Rp&nbsp;".number_format($sisa,0,',','.')."</td>";

    // STATUS
    if($sisa == 0){
        echo "<td><span style='color:#1cc88a;font-weight:bold'>Lunas</span></td>";
        echo "<td>
                <button type='button'
                onclick=\"batalPembayaran({$id})\"
                style='background:#e74a3b;color:white;border:none;padding:6px 12px;border-radius:6px;cursor:pointer'>
                Batal
                </button>
              </td>";
    }else{
        echo "<td><span style='color:#e74a3b;font-weight:bold'>Belum</span></td>";
        echo "<td>
                <button type='button'
                onclick=\"bayarTagihan({$id}, {$sisa})\"
                style='background:#1cc88a;color:white;border:none;padding:6px 12px;border-radius:6px;cursor:pointer'>
                Bayar
                </button>
              </td>";
    }

    echo "</tr>";
}

echo "</table>";
echo "</div>";
?>
